/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.autoversioning;

import org.dspace.content.Item;
import java.util.List;

/**
 *
 *
 * @author Fabio Bolognesi (fabio at atmire dot com)
 * @author Mark Diggory (markd at atmire dot com)
 * @author Ben Bosman (ben at atmire dot com)
 */
public interface AutoVersionHistory {

    public AutoVersion getLatestVersion();
    public AutoVersion getFirstVersion();
    public List<AutoVersion> getVersions();
    public int getVersionHistoryId();
    public AutoVersion getPrevious(AutoVersion version);
    public AutoVersion getNext(AutoVersion version);
    public boolean hasNext(AutoVersion version);
    public void add(AutoVersion version);
    public AutoVersion getVersion(Item item);
    public boolean hasNext(Item item);
    public boolean isFirstVersion(AutoVersion version);
    public boolean isLastVersion(AutoVersion version);
    public void remove(AutoVersion version);
    public boolean isEmpty();
    public int size();
}
