/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.autoversioning;

import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.versioning.Version;

import java.util.Date;

/**
 *
 *
 * @author Fabio Bolognesi (fabio at atmire dot com)
 * @author Mark Diggory (markd at atmire dot com)
 * @author Ben Bosman (ben at atmire dot com)
 */
public interface AutoVersion extends Version
{
    EPerson getEperson();
    int getItemID();
    Date getVersionDate();
    int getVersionNumber();
    void setVersionNumber(int versionNumber);
    String getSummary();
    int getVersionHistoryID();
    String getHandle();
    int getVersionId();
    Item getItem();
    Bitstream getAIPBitstream();
    void setAIPBitstream(int bitstream_id);
    void setItemID(int item_id);
    String getVersionLog();
    void setVersionLog(String log);
    String[] getRestoreVersionLink(Context context,String knotId,String contextPath,boolean isLatestVersion);
    String[] getViewVersionLink(Context context,String knotId,String contextPath,boolean isLatestVersion);
    boolean canEditSummary(Context context,String knotId,String contextPath,boolean isLatestVersion);
    boolean isLastestVersion(Context context,AutoVersionHistory history);
    Bitstream[] getBitstreams(Context context);
    Bitstream getOREBitstream() ;
    void setOREBitstream(int bitstream_id) ;
}

