/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.autoversioning;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.BitstreamUtil;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;

public class AutoVersioningUtil {
    private static Logger log = Logger.getLogger(AutoVersioningUtil.class);
    public static String tableName = "versionitem";
    public static String mapTableName = "Version2Bitstream";
    public static String TYPE_ORE = "ore";
    public static String TYPE_AIP = "aip";
    public static String TYPE_CON = "content";

    public static String getFormat(Bitstream bitstream) {
        BitstreamFormat format = bitstream.getFormat();
        String formatId = format.getMIMEType();
        if (format.getShortDescription().equals("http://www.openarchives.org/ore/terms/")) {
            formatId = "http://www.openarchives.org/ore/terms/";
        } else if (format.getShortDescription().equals("http://www.loc.gov/METS/")) {
            formatId = "http://www.loc.gov/METS/";
        }
        return formatId;
    }

    public static String getPid(Context context, Bitstream bitstream) throws SQLException {
        return "uuid:" + BitstreamUtil.getUuid(context, bitstream);
    }

    public static Bitstream getObsoletedBy(Context c, Bitstream b) {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (AutoVersioningUtil.getBitstreamType(c, b).equals(TYPE_AIP)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                AutoVersionHistory vh = AutoVersioningUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && vh.hasNext(version)) {
                    AutoVersion nextVerison = vh.getNext(version);
                    return nextVerison.getAIPBitstream();
                }
            }
        } else if (AutoVersioningUtil.getBitstreamType(c, b).equals(TYPE_ORE)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where ore_bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                AutoVersionHistory vh = AutoVersioningUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && vh.hasNext(version)) {
                    AutoVersion nextVerison = vh.getNext(version);
                    return nextVerison.getAIPBitstream();
                }
            }
        } else {
            int versionId;
            AutoVersion version;
            AutoVersionHistory vh;
            TableRow row = null;
            String query = "select * from " + mapTableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)mapTableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null && (vh = AutoVersioningUtil.retrieveVersionHistory(c, (version = versioningService.getAutoVersion(c, versionId = row.getIntColumn("version_id"))).getVersionHistoryID())) != null && vh.hasNext(version)) {
                AutoVersion nextVerison = vh.getNext(version);
                return nextVerison.getAIPBitstream();
            }
        }
        return null;
    }

    public static Bitstream getObsoletes(Context c, Bitstream b) {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (AutoVersioningUtil.getBitstreamType(c, b).equals(TYPE_AIP)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                AutoVersion preVersion;
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                AutoVersionHistory vh = AutoVersioningUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && (preVersion = vh.getPrevious(version)) != null) {
                    return preVersion.getAIPBitstream();
                }
            }
        } else if (AutoVersioningUtil.getBitstreamType(c, b).equals(TYPE_ORE)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where ore_bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                AutoVersion preVersion;
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                AutoVersionHistory vh = AutoVersioningUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && (preVersion = vh.getPrevious(version)) != null) {
                    return preVersion.getOREBitstream();
                }
            }
        } else {
            AutoVersion preVersion;
            int versionId;
            AutoVersion version;
            AutoVersionHistory vh;
            TableRow row = null;
            String query = "select * from " + mapTableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)mapTableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null && (vh = AutoVersioningUtil.retrieveVersionHistory(c, (version = versioningService.getAutoVersion(c, versionId = row.getIntColumn("version_id"))).getVersionHistoryID())) != null && (preVersion = vh.getPrevious(version)) != null) {
                return preVersion.getOREBitstream();
            }
        }
        return null;
    }

    private static AutoVersionHistory retrieveVersionHistory(Context c, Integer versionHistoryId) {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (versionHistoryId == null) {
            return null;
        }
        return versioningService.findVersionByHistoryId(c, versionHistoryId);
    }

    public static AutoVersion getVersion(Context c, Bitstream b) {
        String query;
        TableRow row = null;
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (AutoVersioningUtil.getBitstreamType(c, b).equals(TYPE_AIP)) {
            query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (AutoVersioningUtil.getBitstreamType(c, b).equals(TYPE_ORE)) {
            query = "select * from " + tableName + " where ore_bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            query = "select versionitem.versionitem_id as versionitem_id from versionitem, Version2Bitstream where versionitem.versionitem_id=Version2Bitstream.version_id and Version2Bitstream.bitstream_id = ? order by versionitem.version_number DESC";
            try {
                row = DatabaseManager.querySingle((Context)c, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (row != null) {
            int versionId = row.getIntColumn("versionitem_id");
            AutoVersion version = versioningService.getAutoVersion(c, versionId);
            return version;
        }
        return null;
    }

    public static String getBitstreamType(Context c, Bitstream b) {
        TableRow row = null;
        String query = "select * from " + tableName + " where ore_bitstream_id = ?";
        try {
            row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
        }
        catch (Exception e) {
            // empty catch block
        }
        if (row == null) {
            query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row == null) {
                return TYPE_CON;
            }
            return TYPE_AIP;
        }
        return TYPE_ORE;
    }
}

