/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.autoversioning;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionDAO;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersionHistoryDAO;
import org.dspace.autoversioning.AutoVersionHistoryImpl;
import org.dspace.autoversioning.AutoVersionImpl;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.autoversioning.DefaultItemAutoVersionProvider;
import org.dspace.content.AIPManifestWriter;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.OREManifestWriter;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.springframework.beans.factory.annotation.Required;

public class AutoVersioningServiceImpl
implements AutoVersioningService {
    private static final String AIP_PACKAGE_TYPE = "INTERNAL-AIP";
    private static final Logger log = Logger.getLogger(AutoVersioningServiceImpl.class);
    private AutoVersionHistoryDAO versionHistoryDAO;
    private AutoVersionDAO versionDAO;
    private DefaultItemAutoVersionProvider provider;

    @Override
    public AutoVersion createNewWorkingVersionInSubmission(Context c, int itemId, String summary) {
        try {
            Item item = Item.find((Context)c, (int)itemId);
            Date date = new Date();
            if (item == null) {
                AutoVersionHistory history = this.findAutoVersionHistory(c, itemId);
                item = history.getLatestVersion().getItem();
            }
            Item itemNew = this.provider.createNewItemAndAddItInWorkspace(c, item);
            this.provider.updateItemState(c, itemNew, item);
            AutoVersionImpl version = this.updateVersionHistory(c, itemNew, item, summary, "create new version in submission", date);
            return version;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Version createNewVersion(Context c, int itemId) {
        throw new UnsupportedOperationException();
    }

    public Version createNewVersion(Context c, int itemId, String summary) {
        throw new UnsupportedOperationException();
    }

    public void removeVersion(Context c, int versionID) {
        AutoVersionImpl version = this.versionDAO.find(c, versionID);
        if (version != null) {
            this.removeVersion(c, version);
        }
    }

    public void removeVersion(Context c, Item item) {
    }

    public Version getVersion(Context c, int versionID) {
        throw new UnsupportedOperationException();
    }

    public Version restoreVersion(Context c, int versionID) {
        throw new UnsupportedOperationException();
    }

    public Version restoreVersion(Context c, int versionID, String summary) {
        throw new UnsupportedOperationException();
    }

    public VersionHistory findVersionHistory(Context c, int itemId) {
        throw new UnsupportedOperationException();
    }

    public Version updateVersion(Context c, int itemId, String summary) {
        throw new UnsupportedOperationException();
    }

    public Version getVersion(Context c, Item item) {
        return this.versionDAO.findByItemId(c, item.getID());
    }

    protected void removeVersion(Context c, AutoVersion version) {
        try {
            Bitstream bit;
            AutoVersionHistoryImpl history = this.versionHistoryDAO.findById(c, version.getVersionHistoryID(), this.versionDAO);
            this.provider.deleteVersionedItem(c, version, history);
            this.versionDAO.delete(c, version.getVersionId());
            history.remove(version);
            if (history.isEmpty()) {
                this.versionHistoryDAO.delete(c, version.getVersionHistoryID(), this.versionDAO);
            }
            if ((bit = version.getAIPBitstream()) != null) {
                BitstreamUtil.delete(bit);
            }
        }
        catch (Exception e) {
            c.abort();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public AutoVersionHistory findVersionByHistoryId(Context c, int versionHistoryId) {
        try {
            AutoVersionHistoryImpl history = this.versionHistoryDAO.findById(c, versionHistoryId, this.versionDAO);
            return history;
        }
        catch (Exception e) {
            c.abort();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public AutoVersion getAutoVersion(Context c, int versionID) {
        return this.versionDAO.find(c, versionID);
    }

    public Item restoreAutoVersion(Context c, int versionID) {
        return this.restoreAutoVersion(c, versionID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item restoreAutoVersion(Context c, int versionID, String summary) {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        AutoVersion version = versioningService.getAutoVersion(c, versionID);
        AutoVersionHistory versionHistory = versioningService.findVersionByHistoryId(c, version.getVersionHistoryID());
        Bitstream bitstream = version.getAIPBitstream();
        Item newItem = version.getItem();
        if (bitstream != null) {
            AutoVersion latestVersionversion = versionHistory.getLatestVersion();
            Item itemToReplace = latestVersionversion.getItem();
            PackageIngester sip = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, (String)AIP_PACKAGE_TYPE);
            if (sip == null) {
                throw new RuntimeException("No PackageIngester configured with type INTERNAL-AIP");
            }
            File sourceFile = null;
            try {
                sourceFile = File.createTempFile("tmpversion_" + version.getVersionId() + "_sis", null);
                PackageParameters pkgParams = new PackageParameters();
                InputStream inputStream = bitstream.retrieve();
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(sourceFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                }
                pkgParams.setProperty("manifestOnly", "true");
                pkgParams.setProperty("internal", "true");
                pkgParams.setProperty("restoreMode", "true");
                newItem = (Item)sip.replace(c, (DSpaceObject)itemToReplace, sourceFile, pkgParams);
            }
            catch (Exception e) {
                c.abort();
                Throwables.propagate((Throwable)e);
            }
            finally {
                sourceFile.delete();
            }
        }
        return newItem;
    }

    @Override
    public AutoVersionHistory findAutoVersionHistory(Context c, int itemId) {
        return this.versionHistoryDAO.find(c, itemId, this.versionDAO);
    }

    public AutoVersion updateAutoVersion(Context c, int itemId, String summary) {
        AutoVersionImpl version = this.versionDAO.findByItemId(c, itemId);
        version.setSummary(summary);
        this.versionDAO.update(version);
        return version;
    }

    @Override
    public AutoVersion updateVersionByVersionId(Context c, int itemId, int versionId, String summary) {
        AutoVersionImpl version = this.versionDAO.find(c, versionId);
        version.setSummary(summary);
        this.versionDAO.update(version);
        return version;
    }

    public AutoVersion getAutoVersion(Context c, Item item) {
        return this.versionDAO.findByItemId(c, item.getID());
    }

    @Override
    public AutoVersionImpl updateVersionHistory(Context c, Item item, String summary, String log, Date date) {
        return this.updateVersionHistory(c, item, null, null, summary, log, date, false);
    }

    @Override
    public AutoVersionImpl updateVersionHistory(Context c, Item item, int versionId, String summary, String log, Date date) {
        return this.updateVersionHistory(c, item, null, versionId, summary, log, date, false);
    }

    public AutoVersionImpl updateVersionHistory(Context c, Item item, String summary, String log, Date date, boolean restoreMod) {
        return this.updateVersionHistory(c, item, null, null, summary, log, date, restoreMod);
    }

    public AutoVersionImpl updateVersionHistory(Context c, Item newItem, Item previousItem, String summary, String log, Date date) {
        return this.updateVersionHistory(c, newItem, previousItem, null, summary, log, date, false);
    }

    public AutoVersionImpl updateVersionHistory(Context c, Item newItem, Item previousItem, Integer versionId, String summary, String log, Date date, boolean restoreMode) {
        AutoVersionImpl versionImpl = null;
        try {
            AutoVersionHistory history = null;
            if (versionId != null) {
                AutoVersionImpl version = this.versionDAO.find(c, versionId);
                history = this.versionHistoryDAO.findById(c, version.getVersionHistoryID(), this.versionDAO);
            } else {
                history = this.findAutoVersionHistory(c, newItem.getID());
            }
            if (history == null && previousItem != null && (history = this.findAutoVersionHistory(c, previousItem.getID())) == null) {
                AutoVersionImpl origVersion = this.updateVersionHistory(c, previousItem, "Original Version", "", date);
                history = this.findAutoVersionHistory(c, previousItem.getID());
            }
            if (history == null) {
                history = this.versionHistoryDAO.create(c);
            }
            if ((versionImpl = this.versionDAO.findByItem(c, newItem)) == null || versionImpl.getVersionNumber() != -1 || restoreMode) {
                versionImpl = versionId == null ? this.versionDAO.create(c, newItem.getID(), !newItem.isArchived() && !newItem.isWithdrawn()) : this.versionDAO.createWithVersionID(c, history);
                versionImpl.setVersionDate(date);
                versionImpl.setEperson(newItem.getSubmitter());
                versionImpl.setItemID(newItem.getID());
                if (newItem.getHandle() != null) {
                    versionImpl.setHandle(newItem.getHandle());
                }
                versionImpl.setSummary(summary);
                versionImpl.setVersionLog(log);
                if (restoreMode) {
                    versionImpl.setVersionNumber(-1);
                }
                history.add(versionImpl);
                versionImpl.setVersionHistory(history.getVersionHistoryId());
                this.versionDAO.update(versionImpl);
            } else if (!newItem.isArchived() && !newItem.isWithdrawn()) {
                versionImpl.setVersionNumber(-1);
            } else {
                if (previousItem == null) {
                    previousItem = history.getLatestVersion().getItem();
                }
                try {
                    if (previousItem != null && previousItem.getID() != newItem.getID()) {
                        previousItem.withdraw();
                    }
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
                versionImpl.setVersionNumber(this.getNextVersionNumber(c, history));
            }
            if (newItem.isArchived() && !newItem.isWithdrawn() && versionImpl.getAIPBitstream() == null && !restoreMode) {
                AIPManifestWriter aipManifestWriter = new AIPManifestWriter();
                Bitstream bitstream = aipManifestWriter.updateAIP(c, (DSpaceObject)newItem, true);
                versionImpl.setAIPBitstream(bitstream.getID());
                AuthorizeManager.inheritPolicies((Context)c, (DSpaceObject)newItem, (DSpaceObject)bitstream);
                OREManifestWriter oreManifestWriter = new OREManifestWriter();
                Bitstream b = oreManifestWriter.updateORE(c, newItem, versionImpl, true);
                versionImpl.setOREBitstream(b.getID());
                AuthorizeManager.inheritPolicies((Context)c, (DSpaceObject)newItem, (DSpaceObject)b);
                AutoVersionDAO.addBitstreams(c, versionImpl.getVersionId(), newItem.getBundles());
            }
            if (summary != null && summary.length() > 0 && (versionImpl.getSummary() == null || versionImpl.getSummary().length() == 0)) {
                versionImpl.setSummary(summary);
            }
            if (log != null && summary.length() > 0 && (versionImpl.getVersionLog() == null || versionImpl.getVersionLog().length() == 0)) {
                versionImpl.setVersionLog(log);
            }
            if (newItem.getHandle() != null) {
                versionImpl.setHandle(newItem.getHandle());
            } else if (previousItem != null && previousItem.getHandle() != null) {
                versionImpl.setHandle(previousItem.getHandle());
            }
            this.versionDAO.update(versionImpl);
            return versionImpl;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected int getNextVersionNumber(Context c, AutoVersionHistory vh) throws SQLException {
        TableRow row = DatabaseManager.querySingle((Context)c, (String)"SELECT (COALESCE(MAX(version_number), 0) + 1) AS nextversionnumber FROM versionitem WHERE versionhistory_id = ?", (Object[])new Object[]{vh.getVersionHistoryId()});
        int next = row.getIntColumn("nextversionnumber");
        if (vh.getLatestVersion() != null && vh.getLatestVersion().getVersionNumber() >= next) {
            log.debug((Object)("New version number: vh.getLatest....getVersionNumber... = " + Integer.toString(vh.getLatestVersion().getVersionNumber() + 1)));
        }
        return next;
    }

    public AutoVersionHistoryDAO getVersionHistoryDAO() {
        return this.versionHistoryDAO;
    }

    public void setVersionHistoryDAO(AutoVersionHistoryDAO versionHistoryDAO) {
        this.versionHistoryDAO = versionHistoryDAO;
    }

    public AutoVersionDAO getVersionDAO() {
        return this.versionDAO;
    }

    public void setVersionDAO(AutoVersionDAO versionDAO) {
        this.versionDAO = versionDAO;
    }

    @Required
    public void setProvider(DefaultItemAutoVersionProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean canVersion(Context c, Item item) {
        boolean canVersion = false;
        try {
            if (AuthorizeManager.isAdmin((Context)c, (DSpaceObject)item.getOwningCollection()) || AuthorizeManager.authorizeActionBoolean((Context)c, (DSpaceObject)item, (int)1, (boolean)false) || item.getSubmitter().equals((Object)c.getCurrentUser())) {
                canVersion = true;
            } else {
                for (DSpaceObject parentObject = item.getParentObject(); parentObject != null && parentObject.getType() != 5; parentObject = parentObject.getParentObject()) {
                    if (parentObject.getType() != 3 || !AuthorizeManager.authorizeActionBoolean((Context)c, (DSpaceObject)parentObject, (int)3)) continue;
                    canVersion = true;
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return canVersion;
    }

    public void setVersionLog(AutoVersionImpl version, String versionLog) {
        version.setVersionLog(versionLog);
    }
}

