/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.autoversioning;

import java.util.ArrayList;
import java.util.List;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersionHistoryDAO;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.TableRow;

public class AutoVersionHistoryImpl
implements AutoVersionHistory {
    private int versionHistoryId;
    private List<AutoVersion> versions;
    private Context myContext;
    private TableRow myRow;

    protected AutoVersionHistoryImpl(AutoVersionHistoryDAO vhDAO) {
    }

    protected AutoVersionHistoryImpl(Context c, TableRow row) {
        this.myContext = c;
        this.myRow = row;
        c.cache((Object)this, row.getIntColumn("versionhistory_id"));
    }

    @Override
    public int getVersionHistoryId() {
        return this.myRow.getIntColumn("versionhistory_id");
    }

    @Override
    public AutoVersion getPrevious(AutoVersion version) {
        int index = this.versions.indexOf(version);
        if (index + 1 == this.versions.size()) {
            return null;
        }
        return this.versions.get(index + 1);
    }

    @Override
    public AutoVersion getNext(AutoVersion version) {
        int index = this.versions.indexOf(version);
        if (index == 0) {
            return null;
        }
        return this.versions.get(index - 1);
    }

    @Override
    public AutoVersion getVersion(Item item) {
        for (AutoVersion v : this.versions) {
            if (v.getItem() == null || v.getItem().getID() != item.getID()) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean hasNext(Item item) {
        AutoVersion version = this.getVersion(item);
        return this.hasNext(version);
    }

    @Override
    public boolean hasNext(AutoVersion version) {
        return this.getNext(version) != null;
    }

    @Override
    public List<AutoVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<AutoVersion> versions) {
        this.versions = versions;
    }

    @Override
    public void add(AutoVersion version) {
        if (this.versions == null) {
            this.versions = new ArrayList<AutoVersion>();
        }
        this.versions.add(0, version);
    }

    @Override
    public AutoVersion getLatestVersion() {
        if (this.versions == null || this.versions.size() == 0) {
            return null;
        }
        for (AutoVersion version : this.versions) {
            if (version.getVersionNumber() == -1) continue;
            return version;
        }
        return null;
    }

    @Override
    public AutoVersion getFirstVersion() {
        if (this.versions == null || this.versions.size() == 0) {
            return null;
        }
        return this.versions.get(this.versions.size() - 1);
    }

    @Override
    public boolean isFirstVersion(AutoVersion version) {
        AutoVersion first = this.versions.get(this.versions.size() - 1);
        return first.equals(version);
    }

    @Override
    public boolean isLastVersion(AutoVersion version) {
        AutoVersion last = this.versions.get(0);
        return last.equals(version);
    }

    @Override
    public void remove(AutoVersion version) {
        this.versions.remove(version);
    }

    @Override
    public boolean isEmpty() {
        return this.versions.size() == 0;
    }

    @Override
    public int size() {
        return this.versions.size();
    }

    protected TableRow getMyRow() {
        return this.myRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoVersionHistoryImpl that = (AutoVersionHistoryImpl)o;
        return this.versionHistoryId == that.versionHistoryId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.getVersionHistoryId() ^ this.getVersionHistoryId() >>> 32);
        return hash;
    }
}

