/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.autoversioning;

import java.sql.SQLException;
import java.util.List;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionDAO;
import org.dspace.autoversioning.AutoVersionHistoryImpl;
import org.dspace.autoversioning.AutoVersionImpl;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class AutoVersionHistoryDAO {
    protected static final String TABLE_NAME = "versionhistory";
    protected static final String VERSION_HISTORY_ID = "versionhistory_id";

    public AutoVersionHistoryImpl create(Context context) {
        try {
            TableRow row = DatabaseManager.create((Context)context, (String)TABLE_NAME);
            AutoVersionHistoryImpl vh = new AutoVersionHistoryImpl(context, row);
            return vh;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public AutoVersionHistoryImpl find(Context context, int itemID, AutoVersionDAO versionDAO) {
        try {
            AutoVersionImpl version = versionDAO.findByItemId(context, itemID);
            if (version == null) {
                return null;
            }
            AutoVersionHistoryImpl fromCache = (AutoVersionHistoryImpl)context.fromCache(AutoVersionHistoryImpl.class, version.getVersionHistoryID());
            if (fromCache != null) {
                return fromCache;
            }
            TableRow row = DatabaseManager.find((Context)context, (String)TABLE_NAME, (int)version.getVersionHistoryID());
            AutoVersionHistoryImpl vh = new AutoVersionHistoryImpl(context, row);
            List<AutoVersion> versions = versionDAO.findByVersionHistory(context, vh.getVersionHistoryId());
            vh.setVersions(versions);
            return vh;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public AutoVersionHistoryImpl findById(Context context, int id, AutoVersionDAO versionDAO) {
        try {
            TableRow row = DatabaseManager.find((Context)context, (String)TABLE_NAME, (int)id);
            if (row == null) {
                return null;
            }
            AutoVersionHistoryImpl fromCache = (AutoVersionHistoryImpl)context.fromCache(AutoVersionHistoryImpl.class, row.getIntColumn(VERSION_HISTORY_ID));
            if (fromCache != null) {
                return fromCache;
            }
            AutoVersionHistoryImpl versionHistoryImpl = new AutoVersionHistoryImpl(context, row);
            List<AutoVersion> versions = versionDAO.findByVersionHistory(context, versionHistoryImpl.getVersionHistoryId());
            versionHistoryImpl.setVersions(versions);
            return versionHistoryImpl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void delete(Context c, int versionHistoryID, AutoVersionDAO versionDAO) {
        try {
            AutoVersionHistoryImpl history = this.findById(c, versionHistoryID, versionDAO);
            DatabaseManager.delete((Context)c, (TableRow)history.getMyRow());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

