/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.autoversioning;

import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.BitstreamUtil;
import org.dspace.content.OREManifestWriter;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;

import java.sql.SQLException;

/**
 * Created by mdiggory on 10/13/14.
 */
public class AutoVersioningUtil {


    /** log4j category */
    private static Logger log = Logger.getLogger(AutoVersioningUtil.class);
    public static String tableName = "versionitem";
    public static String mapTableName = "Version2Bitstream";
    public static String TYPE_ORE = "ore";
    public static String TYPE_AIP = "aip";
    public static String TYPE_CON = "content";

    public static String getFormat(Bitstream bitstream)
    {
        BitstreamFormat format = bitstream.getFormat();

        String formatId = format.getMIMEType();

        if(format.getShortDescription().equals(OREManifestWriter.ORE.NS))
            formatId = OREManifestWriter.ORE.NS;
        else if(format.getShortDescription().equals("http://www.loc.gov/METS/"))
            formatId = "http://www.loc.gov/METS/";

        return formatId;
    }

    public static String getPid(Context context, Bitstream bitstream) throws SQLException {
        return "uuid:" + BitstreamUtil.getUuid(context, bitstream);
    }


    public static Bitstream getObsoletedBy(Context c, Bitstream b) {
        AutoVersioningService versioningService = (AutoVersioningService) new DSpace().getSingletonService(VersioningService.class);
        if(getBitstreamType(c,b).equals(TYPE_AIP))
        {
            TableRow row = null;
            String query= "select * from "+ tableName+" where bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
            }catch (Exception e)
            {

            }
            if(row!=null)
            {
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                AutoVersionHistory vh = retrieveVersionHistory(c, versionHistoryId);
                if(vh!=null)
                {
                    if(vh.hasNext(version)){
                        AutoVersion nextVerison =  vh.getNext(version);
                        return nextVerison.getAIPBitstream();
                    }
                }
            }

        }
        else if(getBitstreamType(c,b).equals(TYPE_ORE))
        {
            TableRow row = null;
            String query= "select * from "+ tableName+" where ore_bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
            }catch (Exception e)
            {

            }
            if(row!=null)
            {
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                AutoVersionHistory vh = retrieveVersionHistory(c, versionHistoryId);
                if(vh!=null)
                {
                    if(vh.hasNext(version)){
                        AutoVersion nextVerison =  vh.getNext(version);
                        return nextVerison.getAIPBitstream();
                    }
                }
            }

        }
        else
        {
            //this is a content bitstream
            TableRow row = null;
            String query= "select * from "+ mapTableName+" where bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, mapTableName, query,b.getID() );
            }catch (Exception e)
            {

            }
            if(row!=null)
            {
                int versionId = row.getIntColumn("version_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                AutoVersionHistory vh = retrieveVersionHistory(c, version.getVersionHistoryID());
                if(vh!=null)
                {
                    if(vh.hasNext(version)){
                        AutoVersion nextVerison =  vh.getNext(version);
                        return nextVerison.getAIPBitstream();
                    }
                }
            }
        }
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public static Bitstream getObsoletes(Context c, Bitstream b) {
        AutoVersioningService versioningService = (AutoVersioningService) new DSpace().getSingletonService(VersioningService.class);
        if(getBitstreamType(c,b).equals(TYPE_AIP))
        {
            TableRow row = null;
            String query= "select * from "+ tableName+" where bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
            }catch (Exception e)
            {

            }
            if(row!=null)
            {
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                AutoVersionHistory vh = retrieveVersionHistory(c,versionHistoryId);
                if(vh!=null)
                {
                    AutoVersion preVersion =  vh.getPrevious(version);
                    if(preVersion!=null)
                        return preVersion.getAIPBitstream();
                }
            }

        }
        else if(getBitstreamType(c,b).equals(TYPE_ORE))
        {
            TableRow row = null;
            String query= "select * from "+ tableName+" where ore_bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
            }catch (Exception e)
            {

            }
            if(row!=null)
            {
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                int versionId = row.getIntColumn("versionitem_id");
                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                AutoVersionHistory vh = retrieveVersionHistory(c,versionHistoryId);
                if(vh!=null)
                {
                    AutoVersion preVersion =  vh.getPrevious(version);
                    if(preVersion!=null)
                        return preVersion.getOREBitstream();
                }
            }

        }
        else
        {
            //this is a content bitstream
            TableRow row = null;
            String query= "select * from "+ mapTableName+" where bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, mapTableName, query,b.getID() );
            }catch (Exception e)
            {

            }
            if(row!=null)
            {
                int versionId = row.getIntColumn("version_id");

                AutoVersion version = versioningService.getAutoVersion(c, versionId);
                AutoVersionHistory vh = retrieveVersionHistory(c, version.getVersionHistoryID());
                if(vh!=null)
                {
                    AutoVersion preVersion =  vh.getPrevious(version);
                    if(preVersion!=null)
                        return preVersion.getOREBitstream();
                }
            }
        }
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    private static AutoVersionHistory retrieveVersionHistory(Context c, Integer versionHistoryId)
    {
        AutoVersioningService versioningService = (AutoVersioningService) new DSpace().getSingletonService(VersioningService.class);
        if(versionHistoryId==null)
        {
            return null;
        }
        return versioningService.findVersionByHistoryId(c, versionHistoryId);
    }

    public static AutoVersion getVersion(Context c, Bitstream b) {
        TableRow row = null;
        AutoVersioningService versioningService = (AutoVersioningService) new DSpace().getSingletonService(VersioningService.class);
        if(getBitstreamType(c,b).equals(TYPE_AIP))
        {

            String query= "select * from "+tableName+" where bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
            }catch (Exception e)
            {
                log.error(e.getMessage(),e);
            }

        }
        else if(getBitstreamType(c,b).equals(TYPE_ORE))
        {
            String query= "select * from "+tableName+" where ore_bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
            }catch (Exception e)
            {
                log.error(e.getMessage(),e);
            }

        }
        else
        {
            String query= "select versionitem.versionitem_id as versionitem_id from versionitem, Version2Bitstream where versionitem.versionitem_id=Version2Bitstream.version_id and Version2Bitstream.bitstream_id = ? order by versionitem.version_number DESC";
            try{
                row = DatabaseManager.querySingle(c, query,b.getID() );
            }catch (Exception e)
            {
                log.error(e.getMessage(),e);
            }

            //this is a content bitstream
            /*
            try{
                DSpaceObject dSpaceObject =  b.getParentObject();
                Item item = (Item) dSpaceObject;
                VersionHistory vh = versioningService.findAutoVersionHistory(c,item.getID());
                Version version = vh.getLatestVersion();
                return version;


            }
            catch (Exception e)
            {

            }
            */
        }
        if(row!=null)
        {
            int versionId = row.getIntColumn("versionitem_id");
            AutoVersion version = versioningService.getAutoVersion(c, versionId);
            return version;
        }
        return null;  //To change body of implemented methods use File | Settings | File Templates.

    }

    public static String getBitstreamType(Context c, Bitstream b) {

        TableRow row = null;
        String query= "select * from "+tableName+" where ore_bitstream_id = ?";
        try{
            row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
        }catch (Exception e)
        {

        }

        if(row==null)
        {
            query= "select * from "+tableName+" where bitstream_id = ?";
            try{
                row = DatabaseManager.querySingleTable(c, tableName, query,b.getID() );
            }catch (Exception e)
            {

            }
            if(row==null)
            {
                return TYPE_CON;
            }
            else
            {
                return TYPE_AIP;
            }

        }
        else
        {
            return TYPE_ORE;
        }
    }
}
