/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neodatis.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.neodatis.NeoDatisStoreManager;
import org.datanucleus.store.neodatis.NeoDatisUtils;
import org.datanucleus.store.neodatis.query.QueryToCriteriaMapper;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;
import org.neodatis.odb.ODB;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    public JDOQLQuery(ExecutionContext ec) {
        this(ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(ExecutionContext ec, JDOQLQuery q) {
        super(ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(ExecutionContext ec, String query) {
        super(ec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ClassLoaderResolver clr = ((Query)this).ec.getClassLoaderResolver();
        if (((AbstractJavaQuery)this).candidateCollection != null && ((AbstractJavaQuery)this).candidateCollection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        boolean inMemory = this.evaluateInMemory();
        ManagedConnection mconn = ((Query)this).ec.getStoreManager().getConnection(((Query)this).ec);
        ODB odb = (ODB)mconn.getConnection();
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
            }
            ArrayList candidates = null;
            boolean filterInMemory = false;
            boolean orderingInMemory = false;
            if (((AbstractJavaQuery)this).candidateCollection == null) {
                CriteriaQuery query = this.createCriteriaQuery(odb, ((Query)this).compilation, parameters, inMemory);
                candidates = new ArrayList(odb.getObjects((IQuery)query));
                if (inMemory) {
                    filterInMemory = true;
                    orderingInMemory = true;
                }
            } else {
                candidates = new ArrayList(((AbstractJavaQuery)this).candidateCollection);
                filterInMemory = true;
                orderingInMemory = true;
            }
            JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, ((Query)this).compilation, parameters, clr);
            Collection results = resultMapper.execute(filterInMemory, orderingInMemory, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                AbstractClassMetaData cmd = ((Query)this).ec.getMetaDataManager().getMetaDataForClass(obj.getClass(), clr);
                NeoDatisUtils.prepareNeoDatisObjectForUse(obj, ((Query)this).ec, odb, cmd, (NeoDatisStoreManager)((Query)this).ec.getStoreManager());
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    private CriteriaQuery createCriteriaQuery(ODB odb, QueryCompilation compilation, Map parameters, boolean inMemory) {
        CriteriaQuery query = new CriteriaQuery(((Query)this).candidateClass);
        if (((Query)this).subclasses) {
            query.setPolymorphic(true);
        }
        if (!inMemory) {
            new QueryToCriteriaMapper(query, compilation, parameters).compile();
        }
        return query;
    }
}

