/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neodatis.valuegenerator;

import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.neodatis.valuegenerator.NucleusSequence;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.AbstractGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neodatis.odb.ODB;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

public class NeoDatisIncrementGenerator
extends AbstractDatastoreGenerator {
    protected static final Localiser LOCALISER_DB4O = Localiser.getInstance((String)"org.datanucleus.store.neodatis.Localisation", (ClassLoader)(class$org$datanucleus$store$neodatis$NeoDatisStoreManager == null ? (class$org$datanucleus$store$neodatis$NeoDatisStoreManager = NeoDatisIncrementGenerator.class$("org.datanucleus.store.neodatis.NeoDatisStoreManager")) : class$org$datanucleus$store$neodatis$NeoDatisStoreManager).getClassLoader());
    private ODB odb = null;
    private final String sequenceName;
    static /* synthetic */ Class class$org$datanucleus$store$neodatis$NeoDatisStoreManager;
    static /* synthetic */ Class class$org$datanucleus$store$neodatis$valuegenerator$NucleusSequence;

    public NeoDatisIncrementGenerator(String name, Properties props) {
        super(name, props);
        ((AbstractGenerator)this).allocationSize = 5;
        this.sequenceName = ((AbstractGenerator)this).properties.getProperty("sequence-name") != null ? ((AbstractGenerator)this).properties.getProperty("sequence-name") : (((AbstractGenerator)this).properties.getProperty("field-name") != null ? ((AbstractGenerator)this).properties.getProperty("field-name") : ((AbstractGenerator)this).properties.getProperty("class-name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueGenerationBlock obtainGenerationBlock(int number) {
        ValueGenerationBlock block = null;
        try {
            this.odb = (ODB)this.connectionProvider.retrieveConnection().getConnection();
            try {
                block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
            }
            catch (ValueGenerationException poidex) {
                NucleusLogger.VALUEGENERATION.info((Object)AbstractGenerator.LOCALISER.msg("040003", (Object)poidex.getMessage()));
                throw poidex;
            }
            catch (RuntimeException ex) {
                NucleusLogger.VALUEGENERATION.info((Object)AbstractGenerator.LOCALISER.msg("040003", (Object)ex.getMessage()));
                throw ex;
            }
        }
        finally {
            if (this.odb != null) {
                this.connectionProvider.releaseConnection();
                this.odb = null;
            }
        }
        return block;
    }

    protected ValueGenerationBlock reserveBlock(long size) {
        ArrayList<Long> ids = new ArrayList<Long>();
        NucleusSequence seq = null;
        NucleusSequence baseSeq = new NucleusSequence(this.sequenceName);
        CriteriaQuery query = new CriteriaQuery(class$org$datanucleus$store$neodatis$valuegenerator$NucleusSequence == null ? (class$org$datanucleus$store$neodatis$valuegenerator$NucleusSequence = NeoDatisIncrementGenerator.class$("org.datanucleus.store.neodatis.valuegenerator.NucleusSequence")) : class$org$datanucleus$store$neodatis$valuegenerator$NucleusSequence, Where.equal((String)"entityName", (Object)this.sequenceName));
        Objects results = null;
        try {
            results = this.odb.getObjects((IQuery)query);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception thrown getting value for sequence " + this.sequenceName), (Throwable)e);
        }
        if (results != null && results.size() == 1) {
            seq = (NucleusSequence)results.next();
        }
        Long nextVal = null;
        if (seq == null) {
            seq = baseSeq;
            nextVal = new Long(1L);
            seq.setCurrentValue(1L);
        } else {
            nextVal = new Long(seq.getCurrentValue());
        }
        seq.incrementCurrentValue(((AbstractGenerator)this).allocationSize);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER_DB4O.msg("Neodatis.ValueGenerator.UpdatingSequence", (Object)this.sequenceName, (Object)("" + seq.getCurrentValue())));
        }
        int i = 0;
        while ((long)i < size) {
            ids.add(nextVal);
            nextVal = new Long(nextVal + 1L);
            ++i;
        }
        try {
            this.odb.store((Object)seq);
        }
        catch (Exception e) {
            throw new NucleusDataStoreException("Exception thrown updating sequence in NeoDatis for name=" + this.sequenceName, (Throwable)e);
        }
        return new ValueGenerationBlock(ids);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

