/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;
import org.datanucleus.store.types.converters.TypeConverter;
import org.joda.time.Interval;

public class JodaIntervalMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        ColumnMetaData[] colmds = JodaIntervalMapping.getColumnMetaDataForMember((AbstractMemberMetaData)this.mmd, (int)this.roleForMember);
        if (colmds != null && colmds.length == 1) {
            MappingManager mmgr = this.datastoreContainer.getStoreManager().getMappingManager();
            DatastoreField col = mmgr.createDatastoreField((JavaTypeMapping)this, ClassNameConstants.JAVA_LANG_STRING, 0);
            mmgr.createDatastoreMapping((JavaTypeMapping)this, this.mmd, 0, col);
        } else {
            this.addDatastoreField(ClassNameConstants.JAVA_SQL_TIMESTAMP);
            this.addDatastoreField(ClassNameConstants.JAVA_SQL_TIMESTAMP);
        }
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.datastoreMappings != null && this.datastoreMappings.length == 1 && this.datastoreMappings[0].isStringBased()) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return ClassNameConstants.JAVA_SQL_TIMESTAMP;
    }

    public Class getJavaType() {
        return Interval.class;
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        Interval intvl = (Interval)value;
        if (this.getNumberOfDatastoreMappings() == 1) {
            return super.getValueForDatastoreMapping(nucleusCtx, index, value);
        }
        if (index == 0) {
            return intvl.getStartMillis();
        }
        if (index == 1) {
            return intvl.getEndMillis();
        }
        throw new IndexOutOfBoundsException();
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(rs, exprIndex[0]) == null) {
            return null;
        }
        if (this.datastoreMappings != null && this.datastoreMappings.length == 1 && this.datastoreMappings[0].isStringBased()) {
            Object datastoreValue = this.getDatastoreMapping(0).getObject(rs, exprIndex[0]);
            TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(Interval.class, String.class);
            if (conv != null) {
                return conv.toMemberType((Object)((String)datastoreValue));
            }
            throw new NucleusUserException("This type doesn't support persistence as a String");
        }
        Timestamp start = (Timestamp)this.getDatastoreMapping(0).getObject(rs, exprIndex[0]);
        Timestamp end = (Timestamp)this.getDatastoreMapping(1).getObject(rs, exprIndex[1]);
        return new Interval(start.getTime(), end.getTime());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(ExecutionContext ec, Object ps, int[] exprIndex, Object value) {
        Interval interval = (Interval)value;
        if (this.datastoreMappings != null && this.datastoreMappings.length == 1 && this.datastoreMappings[0].isStringBased()) {
            if (value == null) {
                this.getDatastoreMapping(0).setObject(ps, exprIndex[0], null);
                return;
            } else {
                TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(Interval.class, String.class);
                if (conv == null) throw new NucleusUserException("This type doesn't support persistence as a String");
                this.getDatastoreMapping(0).setObject(ps, exprIndex[0], conv.toDatastoreType(value));
            }
            return;
        } else if (interval == null) {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], null);
            this.getDatastoreMapping(1).setObject(ps, exprIndex[1], null);
            return;
        } else {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], (Object)new Timestamp(interval.getStartMillis()));
            this.getDatastoreMapping(1).setObject(ps, exprIndex[1], (Object)new Timestamp(interval.getEndMillis()));
        }
    }
}

