/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Date;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.JodaLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.types.JodaDateTimeStringConverter;
import org.joda.time.DateTime;

public class JodaDateTimeLiteral
extends JodaLiteral {
    private final DateTime value;

    public JodaDateTimeLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, mapping, parameterName);
        if (value == null) {
            this.value = null;
        } else if (value instanceof DateTime) {
            this.value = (DateTime)value;
        } else {
            throw new NucleusException("Cannot create " + ((Object)((Object)this)).getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String str = new JodaDateTimeStringConverter().toString(value);
            this.delegate = new StringLiteral(stmt, mapping, (Object)(this.value != null ? str : null), parameterName);
        } else {
            Date date = new Date();
            date.setTime(((DateTime)value).getMillis());
            this.delegate = new TemporalLiteral(stmt, mapping, (Object)(this.value != null ? date : null), parameterName);
        }
    }

    public Object getValue() {
        return this.value;
    }
}

