/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.sql.Time;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.mapping.TemporalMapping;
import org.datanucleus.store.types.ObjectStringConverter;
import org.joda.time.LocalTime;

public class JodaLocalTimeMapping
extends TemporalMapping {
    public Class getJavaType() {
        return LocalTime.class;
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.datastoreMappings == null || this.datastoreMappings.length == 0) {
            ColumnMetaData[] colmds = JodaLocalTimeMapping.getColumnMetaDataForMember((AbstractMemberMetaData)this.mmd, (int)this.roleForMember);
            boolean useString = false;
            if (colmds != null && colmds.length > 0 && colmds[0].getJdbcType() != null && MetaDataUtils.isJdbcTypeString((String)colmds[0].getJdbcType())) {
                useString = true;
            }
            return useString ? ClassNameConstants.JAVA_LANG_STRING : ClassNameConstants.JAVA_SQL_TIME;
        }
        if (this.datastoreMappings != null && this.datastoreMappings.length > 0 && this.datastoreMappings[0].isStringBased()) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return ClassNameConstants.JAVA_SQL_TIME;
    }

    protected int getDefaultLengthAsString() {
        return 12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        if (value == null) {
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
            return;
        } else if (this.datastoreMappings != null && this.datastoreMappings.length > 0 && this.datastoreMappings[0].isStringBased()) {
            ObjectStringConverter conv = ec.getNucleusContext().getTypeManager().getStringConverter(LocalTime.class);
            if (conv == null) throw new NucleusUserException("This type doesn't support persistence as a String");
            String obj = conv.toString(value);
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], (Object)obj);
            return;
        } else {
            LocalTime val = (LocalTime)value;
            Time time = new Time(val.getHourOfDay(), val.getMinuteOfHour(), val.getSecondOfMinute());
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], (Object)time);
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        if (datastoreValue == null) {
            return null;
        }
        if (datastoreValue instanceof String) {
            ObjectStringConverter conv = ec.getNucleusContext().getTypeManager().getStringConverter(LocalTime.class);
            if (conv != null) {
                return conv.toObject((String)datastoreValue);
            }
            throw new NucleusUserException("This type doesn't support persistence as a String");
        }
        if (datastoreValue instanceof Time) {
            return new LocalTime(((Time)datastoreValue).getTime());
        }
        return null;
    }
}

