/**********************************************************************
Copyright (c) 2009 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.types;

import org.datanucleus.store.types.ObjectStringConverter;
import org.joda.time.LocalTime;
import org.joda.time.format.ISODateTimeFormat;

/**
 * Class to handle the conversion between org.joda.time.LocalTime and a String form.
 * The string form is ISO8601 format ("HH:mm:ss.SSS").
 */
public class JodaLocalTimeStringConverter implements ObjectStringConverter
{
    /* (non-Javadoc)
     * @see org.datanucleus.store.types.ObjectStringConverter#toObject(java.lang.String)
     */
    public Object toObject(String str)
    {
        if (str == null)
        {
            return null;
        }
        return ISODateTimeFormat.hourMinuteSecondMillis().parseDateTime(str).toLocalTime();
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.types.ObjectStringConverter#toString(java.lang.Object)
     */
    public String toString(Object obj)
    {
        String str;
        if (obj instanceof LocalTime)
        {
            str = ((LocalTime)obj).toString("HH:mm:ss.SSS");
        }
        else
        {
            str = (String)obj;
        }
        return str;
    }
}