/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.rest;

import java.lang.reflect.Array;
import java.util.Collection;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.rest.RESTUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ToJSONFieldManager
extends AbstractFieldManager {
    NucleusContext nucCtx;
    JSONObject jsonobj;
    AbstractClassMetaData cmd;
    ExecutionContext ec;

    public ToJSONFieldManager(JSONObject jsonobj, AbstractClassMetaData cmd, ExecutionContext ec) {
        this.jsonobj = jsonobj;
        this.ec = ec;
        this.cmd = cmd;
        this.nucCtx = ec.getNucleusContext();
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (value == null) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (value == null) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            JSONObject obj = RESTUtils.getJSONObjectFromPOJO(value, this.ec);
            try {
                this.jsonobj.put(mmd.getName(), obj);
            }
            catch (JSONException e) {}
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (mmd.hasCollection()) {
                JSONArray arr = new JSONArray();
                Collection collVal = (Collection)value;
                try {
                    int i = 0;
                    for (Object elem : collVal) {
                        JSONObject obj = RESTUtils.getJSONObjectFromPOJO(elem, this.ec);
                        arr.put(i++, obj);
                    }
                    this.jsonobj.put(mmd.getName(), arr);
                }
                catch (JSONException e) {}
            } else if (mmd.hasArray()) {
                JSONArray arr = new JSONArray();
                try {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        JSONObject obj = RESTUtils.getJSONObjectFromPOJO(Array.get(value, i), this.ec);
                        arr.put(i++, obj);
                    }
                    this.jsonobj.put(mmd.getName(), arr);
                }
                catch (JSONException e) {}
            }
        } else {
            try {
                this.jsonobj.put(mmd.getName(), value);
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
    }
}

