/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.rest.RESTUtils;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.NucleusLogger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestServlet
extends HttpServlet {
    public static final NucleusLogger LOGGER_REST = NucleusLogger.getLoggerInstance((String)"DataNucleus.REST");
    PersistenceManagerFactory pmf;
    NucleusContext nucCtx;

    public void destroy() {
        if (this.pmf != null && !this.pmf.isClosed()) {
            LOGGER_REST.info((Object)"REST : Closing PMF");
            this.pmf.close();
        }
        super.destroy();
    }

    public void init(ServletConfig config) throws ServletException {
        String factory = config.getInitParameter("persistence-context");
        if (factory == null) {
            throw new ServletException("You haven't specified \"persistence-context\" property defining the persistence unit");
        }
        try {
            LOGGER_REST.info((Object)("REST : Creating PMF for factory=" + factory));
            this.pmf = JDOHelper.getPersistenceManagerFactory((String)factory);
            this.nucCtx = ((JDOPersistenceManagerFactory)this.pmf).getNucleusContext();
        }
        catch (Exception e) {
            LOGGER_REST.error((Object)"Exception creating PMF", (Throwable)e);
            throw new ServletException("Could not create internal PMF. See nested exception for details", (Throwable)e);
        }
        super.init(config);
    }

    private String getNextTokenAfterSlash(HttpServletRequest req) {
        String path = req.getRequestURI().substring(req.getContextPath().length() + req.getServletPath().length());
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        return tokenizer.nextToken();
    }

    private Object getId(HttpServletRequest req) {
        ClassLoaderResolver clr = this.nucCtx.getClassLoaderResolver(RestServlet.class.getClassLoader());
        String path = req.getRequestURI().substring(req.getContextPath().length() + req.getServletPath().length());
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        String className = tokenizer.nextToken();
        AbstractClassMetaData cmd = this.nucCtx.getMetaDataManager().getMetaDataForClass(className, clr);
        String id = null;
        if (tokenizer.hasMoreTokens()) {
            id = tokenizer.nextToken();
            if (id == null || cmd == null) {
                return null;
            }
            Object identity = RESTUtils.getIdentityForURLToken(cmd, id, this.nucCtx);
            if (identity != null) {
                return identity;
            }
        }
        try {
            if (id == null && req.getContentLength() > 0) {
                char[] buffer = new char[req.getContentLength()];
                req.getReader().read(buffer);
                id = new String(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (id == null || cmd == null) {
            return null;
        }
        try {
            id = URLDecoder.decode(id, "UTF-8");
            JSONObject jsonobj = new JSONObject(id);
            return RESTUtils.getNonPersistableObjectFromJSONObject(jsonobj, clr.classForName(cmd.getObjectidClass()), this.nucCtx);
        }
        catch (JSONException ex) {
        }
        catch (UnsupportedEncodingException e) {
            LOGGER_REST.error((Object)"Exception caught when trying to determine id", (Throwable)e);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String token = this.getNextTokenAfterSlash(req);
            if (token.equalsIgnoreCase("query") || token.equalsIgnoreCase("jdoql")) {
                String queryString = URLDecoder.decode(req.getQueryString(), "UTF-8");
                PersistenceManager pm = this.pmf.getPersistenceManager();
                try {
                    pm.currentTransaction().begin();
                    Query query = pm.newQuery("JDOQL", (Object)queryString);
                    Object result = query.execute();
                    if (result instanceof Collection) {
                        JSONArray jsonobj = RESTUtils.getJSONArrayFromCollection((Collection)result, ((JDOPersistenceManager)pm).getExecutionContext());
                        resp.getWriter().write(jsonobj.toString());
                    } else {
                        JSONObject jsonobj = RESTUtils.getJSONObjectFromPOJO(result, ((JDOPersistenceManager)pm).getExecutionContext());
                        resp.getWriter().write(jsonobj.toString());
                    }
                    resp.setHeader("Content-Type", "application/json");
                    resp.setStatus(200);
                    pm.currentTransaction().commit();
                }
                finally {
                    if (pm.currentTransaction().isActive()) {
                        pm.currentTransaction().rollback();
                    }
                    pm.close();
                }
                return;
            }
            if (token.equalsIgnoreCase("jpql")) {
                String queryString = URLDecoder.decode(req.getQueryString(), "UTF-8");
                PersistenceManager pm = this.pmf.getPersistenceManager();
                try {
                    pm.currentTransaction().begin();
                    Query query = pm.newQuery("JPQL", (Object)queryString);
                    Object result = query.execute();
                    if (result instanceof Collection) {
                        JSONArray jsonobj = RESTUtils.getJSONArrayFromCollection((Collection)result, ((JDOPersistenceManager)pm).getExecutionContext());
                        resp.getWriter().write(jsonobj.toString());
                    } else {
                        JSONObject jsonobj = RESTUtils.getJSONObjectFromPOJO(result, ((JDOPersistenceManager)pm).getExecutionContext());
                        resp.getWriter().write(jsonobj.toString());
                    }
                    resp.setHeader("Content-Type", "application/json");
                    resp.setStatus(200);
                    pm.currentTransaction().commit();
                }
                finally {
                    if (pm.currentTransaction().isActive()) {
                        pm.currentTransaction().rollback();
                    }
                    pm.close();
                }
                return;
            }
            String className = token;
            ClassLoaderResolver clr = this.nucCtx.getClassLoaderResolver(RestServlet.class.getClassLoader());
            AbstractClassMetaData cmd = this.nucCtx.getMetaDataManager().getMetaDataForEntityName(className);
            try {
                if (cmd == null) {
                    cmd = this.nucCtx.getMetaDataManager().getMetaDataForClass(className, clr);
                }
            }
            catch (ClassNotResolvedException ex) {
                JSONObject error = new JSONObject();
                error.put("exception", ex.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(404);
                resp.setHeader("Content-Type", "application/json");
                return;
            }
            Object id = this.getId(req);
            if (id == null) {
                try {
                    String queryString = "SELECT FROM " + cmd.getFullClassName();
                    if (req.getQueryString() != null) {
                        queryString = queryString + " WHERE " + URLDecoder.decode(req.getQueryString(), "UTF-8");
                    }
                    PersistenceManager pm = this.pmf.getPersistenceManager();
                    try {
                        pm.currentTransaction().begin();
                        Query query = pm.newQuery("JDOQL", (Object)queryString);
                        List result = (List)query.execute();
                        JSONArray jsonobj = RESTUtils.getJSONArrayFromCollection(result, ((JDOPersistenceManager)pm).getExecutionContext());
                        resp.getWriter().write(jsonobj.toString());
                        resp.setHeader("Content-Type", "application/json");
                        resp.setStatus(200);
                        pm.currentTransaction().commit();
                    }
                    finally {
                        if (pm.currentTransaction().isActive()) {
                            pm.currentTransaction().rollback();
                        }
                        pm.close();
                    }
                    return;
                }
                catch (NucleusUserException e) {
                    JSONObject error = new JSONObject();
                    error.put("exception", e.getMessage());
                    resp.getWriter().write(error.toString());
                    resp.setStatus(400);
                    resp.setHeader("Content-Type", "application/json");
                    return;
                }
                catch (NucleusException ex) {
                    JSONObject error = new JSONObject();
                    error.put("exception", ex.getMessage());
                    resp.getWriter().write(error.toString());
                    resp.setStatus(404);
                    resp.setHeader("Content-Type", "application/json");
                    return;
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    JSONObject error = new JSONObject();
                    error.put("exception", ex.getMessage());
                    resp.getWriter().write(error.toString());
                    resp.setStatus(404);
                    resp.setHeader("Content-Type", "application/json");
                    return;
                }
            }
            PersistenceManager pm = this.pmf.getPersistenceManager();
            try {
                pm.currentTransaction().begin();
                Object result = pm.getObjectById(id);
                JSONObject jsonobj = RESTUtils.getJSONObjectFromPOJO(result, ((JDOPersistenceManager)pm).getExecutionContext());
                resp.getWriter().write(jsonobj.toString());
                resp.setHeader("Content-Type", "application/json");
                pm.currentTransaction().commit();
                return;
            }
            catch (NucleusObjectNotFoundException ex) {
                resp.setContentLength(0);
                resp.setStatus(404);
                return;
            }
            catch (NucleusException ex) {
                JSONObject error = new JSONObject();
                error.put("exception", ex.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(404);
                resp.setHeader("Content-Type", "application/json");
                return;
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
        }
        catch (JSONException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(404);
                resp.setHeader("Content-Type", "application/json");
            }
            catch (JSONException e1) {
                // empty catch block
            }
            return;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("Allow", " GET, HEAD, POST, PUT, TRACE, OPTIONS");
        resp.setContentLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getContentLength() < 1) {
            resp.setContentLength(0);
            resp.setStatus(400);
            return;
        }
        char[] buffer = new char[req.getContentLength()];
        req.getReader().read(buffer);
        String str = new String(buffer);
        PersistenceManager pm = this.pmf.getPersistenceManager();
        ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
        try {
            String idToken;
            Object id;
            pm.currentTransaction().begin();
            JSONObject jsonobj = new JSONObject(str);
            String className = this.getNextTokenAfterSlash(req);
            jsonobj.put("class", className);
            AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(className, ec.getClassLoaderResolver());
            String path = req.getRequestURI().substring(req.getContextPath().length() + req.getServletPath().length());
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            tokenizer.nextToken();
            if (tokenizer.hasMoreTokens() && (id = RESTUtils.getIdentityForURLToken(cmd, idToken = tokenizer.nextToken(), this.nucCtx)) != null) {
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    if (cmd.usesSingleFieldIdentityClass()) {
                        jsonobj.put(cmd.getPrimaryKeyMemberNames()[0], ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(id));
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    jsonobj.put("_id", ((OID)id).getKeyValue());
                }
            }
            Object pc = RESTUtils.getObjectFromJSONObject(jsonobj, className, ec);
            Object obj = pm.makePersistent(pc);
            JSONObject jsonobj2 = RESTUtils.getJSONObjectFromPOJO(obj, ec);
            resp.getWriter().write(jsonobj2.toString());
            resp.setHeader("Content-Type", "application/json");
            pm.currentTransaction().commit();
        }
        catch (ClassNotResolvedException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(500);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (NucleusUserException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(400);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (NucleusException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(500);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (JSONException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(500);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
        resp.setStatus(201);
    }

    /*
     * Exception decompiling
     */
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String className = this.getNextTokenAfterSlash(req);
        ClassLoaderResolver clr = this.nucCtx.getClassLoaderResolver(RestServlet.class.getClassLoader());
        AbstractClassMetaData cmd = this.nucCtx.getMetaDataManager().getMetaDataForEntityName(className);
        try {
            if (cmd == null) {
                cmd = this.nucCtx.getMetaDataManager().getMetaDataForClass(className, clr);
            }
        }
        catch (ClassNotResolvedException ex) {
            resp.setStatus(404);
            return;
        }
        Object id = this.getId(req);
        if (id == null) {
            try {
                String queryString = "SELECT FROM " + cmd.getFullClassName();
                if (req.getQueryString() != null) {
                    queryString = queryString + " WHERE " + URLDecoder.decode(req.getQueryString(), "UTF-8");
                }
                PersistenceManager pm = this.pmf.getPersistenceManager();
                try {
                    pm.currentTransaction().begin();
                    Query query = pm.newQuery("JDOQL", (Object)queryString);
                    query.execute();
                    resp.setStatus(200);
                    pm.currentTransaction().commit();
                }
                finally {
                    if (pm.currentTransaction().isActive()) {
                        pm.currentTransaction().rollback();
                    }
                    pm.close();
                }
                return;
            }
            catch (NucleusUserException e) {
                resp.setStatus(400);
                return;
            }
            catch (NucleusException ex) {
                resp.setStatus(404);
                return;
            }
            catch (RuntimeException ex) {
                resp.setStatus(404);
                return;
            }
        }
        PersistenceManager pm = this.pmf.getPersistenceManager();
        try {
            pm.currentTransaction().begin();
            pm.getObjectById(id);
            resp.setStatus(200);
            pm.currentTransaction().commit();
            return;
        }
        catch (NucleusException ex) {
            resp.setStatus(404);
            return;
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }
}

