/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.rest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.rest.DummyStateManager;
import org.datanucleus.api.rest.FromJSONFieldManager;
import org.datanucleus.api.rest.RestServlet;
import org.datanucleus.api.rest.ToJSONFieldManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RESTUtils {
    public static JSONArray getJSONArrayFromCollection(Collection coll, ExecutionContext ec) {
        JSONArray arr = new JSONArray();
        int i = 0;
        for (Object elem : coll) {
            try {
                arr.put(i++, RESTUtils.getJSONObjectFromPOJO(elem, ec));
            }
            catch (JSONException e) {}
        }
        return arr;
    }

    public static JSONObject getJSONObjectFromPOJO(Object obj, ExecutionContext ec) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(obj.getClass(), clr);
        JSONObject jsonobj = new JSONObject();
        try {
            jsonobj.put("class", cmd.getFullClassName());
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                OID oid = (OID)ec.getApiAdapter().getIdForObject(obj);
                jsonobj.put("_id", oid.getKeyValue());
            }
            if (ec.getApiAdapter().getVersionForObject(obj) != null) {
                Object ver = ec.getApiAdapter().getVersionForObject(obj);
                jsonobj.put("_version", ver);
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        ObjectProvider op = ec.findObjectProvider(obj);
        ec.getFetchPlan().manageFetchPlanForClass(cmd);
        int[] fpMembers = ec.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
        ToJSONFieldManager fm = new ToJSONFieldManager(jsonobj, cmd, ec);
        op.provideFields(fpMembers, (FieldManager)fm);
        return jsonobj;
    }

    public static Object getObjectFromJSONObject(JSONObject jsonobj, String className, ExecutionContext ec) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForEntityName(className);
        Class cls = null;
        if (cmd != null) {
            cls = clr.classForName(cmd.getFullClassName(), true);
        } else {
            cls = clr.classForName(className, true);
            cmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
        }
        if (cmd == null) {
            return RESTUtils.getNonPersistableObjectFromJSONObject(jsonobj, cls, ec.getNucleusContext());
        }
        Object id = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            FromJSONFieldManager fm = new FromJSONFieldManager(jsonobj, cmd, ec);
            try {
                id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, (Class)cls, (boolean)false, (FieldManager)fm);
            }
            catch (NucleusException ne) {}
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            try {
                if (MetaDataUtils.getTypeOfDatastoreIdentity((IdentityMetaData)cmd.getBaseIdentityMetaData()) == String.class) {
                    String idVal = jsonobj.getString("_id");
                    id = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)className, (Object)idVal);
                } else {
                    long idVal = jsonobj.getLong("_id");
                    id = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)className, (Object)idVal);
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        if (id != null) {
            try {
                Object pc = ec.findObject(id, true, false, cmd.getFullClassName());
                ObjectProvider pcOP = ec.findObjectProvider(pc);
                FromJSONFieldManager fm2 = new FromJSONFieldManager(jsonobj, cmd, pcOP);
                pcOP.replaceFields(cmd.getAllMemberPositions(), (FieldManager)fm2);
                return pc;
            }
            catch (NucleusException ne) {
                FromJSONFieldManager fm = new FromJSONFieldManager(jsonobj, cmd, ec);
                DummyStateManager dummySM = new DummyStateManager(cls);
                int[] fieldNumbers = cmd.getAllMemberPositions();
                dummySM.replaceFields(fieldNumbers, (FieldManager)fm);
                Object obj = dummySM.getObject();
                dummySM.disconnect();
                return obj;
            }
        }
        FromJSONFieldManager fm = new FromJSONFieldManager(jsonobj, cmd, ec);
        DummyStateManager dummySM = new DummyStateManager(cls);
        int[] fieldNumbers = cmd.getAllMemberPositions();
        dummySM.replaceFields(fieldNumbers, (FieldManager)fm);
        Object obj = dummySM.getObject();
        dummySM.disconnect();
        return obj;
    }

    public static Object getIdentityForURLToken(AbstractClassMetaData cmd, String token, NucleusContext nucCtx) {
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            if (cmd.usesSingleFieldIdentityClass()) {
                ClassLoaderResolver clr = nucCtx.getClassLoaderResolver(RestServlet.class.getClassLoader());
                Object value = TypeConversionHelper.convertTo((Object)token, (Class)cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[0]).getType());
                return nucCtx.getApiAdapter().getNewSingleFieldIdentity(clr.classForName(cmd.getObjectidClass()), clr.classForName(cmd.getFullClassName()), value);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            Class type = MetaDataUtils.getTypeOfDatastoreIdentity((IdentityMetaData)cmd.getBaseIdentityMetaData());
            Object value = TypeConversionHelper.convertTo((Object)token, (Class)type);
            return OIDFactory.getInstance((NucleusContext)nucCtx, (String)cmd.getFullClassName(), (Object)value);
        }
        return null;
    }

    public static Object getNonPersistableObjectFromJSONObject(final JSONObject jsonobj, final Class cls, NucleusContext nucCtx) {
        ClassLoaderResolver clr = nucCtx.getClassLoaderResolver(RestServlet.class.getClassLoader());
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            String email = null;
            String authDomain = null;
            try {
                email = jsonobj.getString("email");
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                authDomain = jsonobj.getString("authDomain");
            }
            catch (JSONException e) {
                // empty catch block
            }
            return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{email, authDomain});
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            try {
                Object parent = null;
                if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                    JSONObject parentobj = jsonobj.getJSONObject("parent");
                    parent = RESTUtils.getNonPersistableObjectFromJSONObject(parentobj, clr.classForName(jsonobj.getString("class")), nucCtx);
                }
                if (jsonobj.has("appId")) {
                    String appId = jsonobj.getString("appId");
                    String kind = jsonobj.getString("kind");
                    Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", false);
                    if (parent != null) {
                        return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, String.class}).invoke(null, parent, kind, appId);
                    }
                    return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, String.class}).invoke(null, kind, appId);
                }
                long id = jsonobj.getLong("id");
                String kind = jsonobj.getString("kind");
                Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", false);
                if (parent != null) {
                    return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, Long.TYPE}).invoke(null, parent, kind, id);
                }
                return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, Long.TYPE}).invoke(null, kind, id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        c.setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            field.setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (Exception e) {
                        NucleusLogger.GENERAL.error((Object)"Exception in conversion from JSONObject field to value", (Throwable)e);
                        return null;
                    }
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

