/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.rest;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.rest.RESTUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FromJSONFieldManager
extends AbstractFieldManager {
    NucleusContext nucCtx;
    JSONObject jsonobj;
    AbstractClassMetaData cmd;
    ExecutionContext ec;
    ObjectProvider op;

    public FromJSONFieldManager(JSONObject jsonobj, AbstractClassMetaData cmd, ExecutionContext ec) {
        this.jsonobj = jsonobj;
        this.cmd = cmd;
        this.ec = ec;
        this.nucCtx = ec.getNucleusContext();
    }

    public FromJSONFieldManager(JSONObject jsonobj, AbstractClassMetaData cmd, ObjectProvider op) {
        this.jsonobj = jsonobj;
        this.cmd = cmd;
        this.op = op;
        this.ec = op.getExecutionContext();
        this.nucCtx = this.ec.getNucleusContext();
    }

    public String fetchStringField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return null;
        }
        try {
            String val = this.jsonobj.getString(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public short fetchShortField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0;
        }
        try {
            short val = (short)this.jsonobj.getInt(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0;
        }
    }

    public Object fetchObjectField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return null;
        }
        try {
            if (this.jsonobj.isNull(fieldName)) {
                return null;
            }
            Object value = this.jsonobj.get(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            if (value instanceof JSONObject) {
                return RESTUtils.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.ec);
            }
            if (value instanceof JSONArray) {
                return this.fetchJSONArray((JSONArray)value, position);
            }
            return TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType());
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List fetchJSONArray(JSONArray array, int position) throws JSONException {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            if (array.isNull(i)) {
                elements.add(null);
                continue;
            }
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                elements.add(RESTUtils.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.ec));
                continue;
            }
            if (value instanceof JSONArray) {
                elements.add(this.fetchJSONArray((JSONArray)value, position));
                continue;
            }
            elements.add(TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType()));
        }
        return elements;
    }

    public long fetchLongField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0L;
        }
        try {
            long val = this.jsonobj.getLong(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0L;
        }
    }

    public int fetchIntField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0;
        }
        try {
            int val = this.jsonobj.getInt(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0;
        }
    }

    public float fetchFloatField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0.0f;
        }
        try {
            float val = (float)this.jsonobj.getDouble(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0.0f;
        }
    }

    public double fetchDoubleField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0.0;
        }
        try {
            double val = this.jsonobj.getDouble(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0.0;
        }
    }

    public char fetchCharField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return '\u0000';
        }
        try {
            String str = this.jsonobj.getString(fieldName);
            char value = '\u0000';
            if (str != null && str.length() > 0) {
                value = str.charAt(0);
            }
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return value;
        }
        catch (JSONException jSONException) {
            return '\u0000';
        }
    }

    public byte fetchByteField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0;
        }
        try {
            String str = this.jsonobj.getString(fieldName);
            byte value = 0;
            if (str != null && str.length() > 0) {
                value = str.getBytes()[0];
            }
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return value;
        }
        catch (JSONException jSONException) {
            return 0;
        }
    }

    public boolean fetchBooleanField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return false;
        }
        try {
            boolean val = this.jsonobj.getBoolean(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }
}

