/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.support.messaging.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dataconservancy.pass.support.messaging.json.JsonParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class JsonParserTest {
    @Rule
    public TestName testName = new TestName();
    private JsonParser underTest;

    @Before
    public void setUp() throws Exception {
        this.underTest = new JsonParser(new ObjectMapper());
    }

    @Test
    public void parseId() throws Exception {
        String expectedId = "http://fcrepo:8080/fcrepo/rest/submissions/92/42/2a/d3/92422ad3-6384-46cf-98ff-332ff151000b";
        String resourceName = this.getClass().getSimpleName() + "-" + this.testName.getMethodName() + ".json";
        URL jsonUrl = this.getClass().getResource(resourceName);
        Assert.assertNotNull((String)("Cannot resolve " + resourceName + " on the classpath."), (Object)jsonUrl);
        byte[] body = IOUtils.toByteArray((InputStream)jsonUrl.openStream());
        Assert.assertNotNull((String)("Null resource " + jsonUrl), (Object)body);
        Assert.assertTrue((String)("Empty resource " + jsonUrl), (body.length > 0 ? 1 : 0) != 0);
        String submissionUri = this.underTest.parseId(body);
        Assert.assertNotNull((String)("Failed to resolve an id from resource " + jsonUrl), (Object)submissionUri);
        Assert.assertEquals((Object)expectedId, (Object)submissionUri);
    }

    @Test
    public void parseRepositories() throws Exception {
        String resourceName = this.getClass().getSimpleName() + "-" + this.testName.getMethodName() + ".json";
        URL jsonUrl = this.getClass().getResource(resourceName);
        Assert.assertNotNull((String)("Cannot resolve " + resourceName + " on the classpath."), (Object)jsonUrl);
        byte[] body = IOUtils.toByteArray((InputStream)jsonUrl.openStream());
        Assert.assertNotNull((String)("Null resource " + jsonUrl), (Object)body);
        Assert.assertTrue((String)("Empty resource " + jsonUrl), (body.length > 0 ? 1 : 0) != 0);
        List<String> expectedUris = Arrays.asList("http://192.168.99.100:8080/fcrepo/rest/repositories/7a/59/0c/55/7a590c55-b431-458f-a30f-3bcff312f9e3", "http://192.168.99.100:8080/fcrepo/rest/repositories/44/23/5c/60/44235c60-4dea-4838-84fa-c62aa6d13316", "http://192.168.99.100:8080/fcrepo/rest/repositories/dc/35/36/96/dc353696-3245-4969-a9b6-5edc70c91be0");
        Collection repoUris = this.underTest.parseRepositoryUris(body);
        Assert.assertEquals((long)expectedUris.size(), (long)repoUris.size());
        expectedUris.forEach(uri -> Assert.assertTrue((boolean)repoUris.contains(uri)));
    }

    @Test
    public void parseRepositories2() throws Exception {
        String resourceName = this.getClass().getSimpleName() + "-" + this.testName.getMethodName() + ".json";
        URL jsonUrl = this.getClass().getResource(resourceName);
        Assert.assertNotNull((String)("Cannot resolve " + resourceName + " on the classpath."), (Object)jsonUrl);
        byte[] body = IOUtils.toByteArray((InputStream)jsonUrl.openStream());
        Assert.assertNotNull((String)("Null resource " + jsonUrl), (Object)body);
        Assert.assertTrue((String)("Empty resource " + jsonUrl), (body.length > 0 ? 1 : 0) != 0);
        List<String> expectedUris = Arrays.asList("http://192.168.99.100:8080/fcrepo/rest/repositories/js", "http://192.168.99.100:8080/fcrepo/rest/repositories/nih");
        Collection repoUris = this.underTest.parseRepositoryUris(body);
        Assert.assertEquals((long)expectedUris.size(), (long)repoUris.size());
        expectedUris.forEach(uri -> Assert.assertTrue((boolean)repoUris.contains(uri)));
    }
}

