/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.support.messaging.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JsonParser {
    private ObjectMapper objectMapper;

    @Autowired
    public JsonParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String parseId(byte[] json) {
        JsonNode node = JsonParser.toJsonNode(json, this.objectMapper);
        if (node == null) {
            throw new RuntimeException("Unable to resolve the following to JSON:\n" + new String(json));
        }
        JsonNode value = node.findValue("id");
        return value == null ? null : value.asText();
    }

    public String parseEtag(byte[] json) {
        JsonNode node = JsonParser.toJsonNode(json, this.objectMapper);
        if (node == null) {
            throw new RuntimeException("Unable to resolve the following to JSON:\n" + new String(json));
        }
        JsonNode value = node.findValue("etag");
        return value == null ? null : value.asText();
    }

    public Collection<String> parseRepositoryUris(byte[] json) {
        JsonNode node = JsonParser.toJsonNode(json, this.objectMapper);
        if (node == null) {
            throw new RuntimeException("Unable to resolve the following to JSON:\n" + new String(json));
        }
        JsonNode contains = node.findValue("http://www.w3.org/ns/ldp#contains");
        if (contains == null) {
            throw new RuntimeException("JSON is missing 'http://www.w3.org/ns/ldp#contains': unable to resolve repository URIs from the following JSON:\n" + new String(json));
        }
        ArrayList<String> repoUris = new ArrayList<String>();
        contains.iterator().forEachRemaining(n -> repoUris.add(n.findValue("@id").asText()));
        return repoUris;
    }

    private static JsonNode toJsonNode(byte[] json, ObjectMapper objectMapper) {
        JsonNode node = null;
        try {
            node = objectMapper.readTree(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read JSON byte array: " + e.getMessage(), e);
        }
        return node;
    }
}

