/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.support.messaging.cri;

import java.util.function.Function;
import java.util.function.Predicate;
import org.dataconservancy.pass.client.PassClient;
import org.dataconservancy.pass.model.PassEntity;
import org.dataconservancy.pass.support.messaging.cri.ConflictHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultConflictHandler
implements ConflictHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConflictHandler.class);
    private PassClient passClient;

    public DefaultConflictHandler(PassClient passClient) {
        this.passClient = passClient;
    }

    @Override
    public <T extends PassEntity, R> R handleConflict(T conflictedResource, Class<T> resourceClass, Predicate<T> preCondition, Function<T, R> criticalUpdate) {
        String msg;
        LOG.trace("Retrying update for {}, version {}", (Object)conflictedResource.getId(), (Object)conflictedResource.getVersionTag());
        PassEntity toUpdate = null;
        try {
            toUpdate = this.passClient.readResource(conflictedResource.getId(), resourceClass);
        }
        catch (Exception e) {
            msg = String.format("Update retry failed for %s (version %s): Unable to successfully re-read the latest version of the resource when retrying: %s", conflictedResource.getId(), conflictedResource.getVersionTag(), e.getMessage());
            LOG.debug(msg, (Throwable)e);
        }
        try {
            if (!preCondition.test(toUpdate)) {
                String msg2 = String.format("Update retry failed for %s (version %s to %s): does not the satisfy the precondition for update.", conflictedResource.getId(), conflictedResource.getVersionTag(), toUpdate.getVersionTag());
                throw new RuntimeException(msg2);
            }
            R toReturn = criticalUpdate.apply(toUpdate);
            this.passClient.updateResource(toUpdate);
            return toReturn;
        }
        catch (Exception e) {
            msg = String.format("Update retry failed for %s (version %s to %s)", conflictedResource.getId(), conflictedResource.getVersionTag(), toUpdate.getVersionTag());
            LOG.debug(msg, (Throwable)e);
            return null;
        }
    }
}

