/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.support.messaging.cri;

import java.net.URI;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dataconservancy.pass.client.PassClient;
import org.dataconservancy.pass.client.fedora.UpdateConflictException;
import org.dataconservancy.pass.model.PassEntity;
import org.dataconservancy.pass.support.messaging.cri.ConflictHandler;
import org.dataconservancy.pass.support.messaging.cri.CriticalRepositoryInteraction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CriticalPath
implements CriticalRepositoryInteraction {
    private static final Logger LOG = LoggerFactory.getLogger(CriticalPath.class);
    private PassClient passClient;
    private ConflictHandler conflictHandler;

    public CriticalPath(PassClient passClient, ConflictHandler conflictHandler) {
        this.passClient = passClient;
        this.conflictHandler = conflictHandler;
    }

    @Override
    public <R, T extends PassEntity> CriticalRepositoryInteraction.CriticalResult<R, T> performCritical(URI uri, Class<T> clazz, Predicate<T> precondition, Predicate<T> postcondition, Function<T, R> critical) {
        return this.performCritical(uri, clazz, precondition, (T t, R r) -> postcondition.test(t), critical);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, T extends PassEntity> CriticalRepositoryInteraction.CriticalResult<R, T> performCritical(URI uri, Class<T> clazz, Predicate<T> precondition, BiPredicate<T, R> postcondition, Function<T, R> critical) {
        CriticalRepositoryInteraction.CriticalResult<Object, PassEntity> cr = null;
        String string = uri.toString().intern();
        synchronized (string) {
            PassEntity resource = null;
            try {
                resource = this.passClient.readResource(uri, clazz);
            }
            catch (Exception e) {
                return new CriticalRepositoryInteraction.CriticalResult<Object, Object>(null, null, false, e);
            }
            try {
                if (!precondition.test(resource)) {
                    LOG.debug("Precondition for applying the critical path on resource {} failed.", (Object)resource.getId());
                    return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(null, resource, false);
                }
            }
            catch (Exception e) {
                return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(null, resource, false, e);
            }
            Object updateResult = null;
            boolean updated = false;
            try {
                int before = resource.hashCode();
                updateResult = critical.apply(resource);
                updated = before != resource.hashCode();
            }
            catch (Exception e) {
                return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(updateResult, resource, false, e);
            }
            try {
                resource = updated ? this.passClient.updateAndReadResource(resource, resource.getClass()) : this.passClient.readResource(resource.getId(), resource.getClass());
            }
            catch (UpdateConflictException e) {
                try {
                    updateResult = this.conflictHandler.handleConflict(resource, clazz, precondition, critical);
                    if (updateResult == null) {
                        return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(null, resource, false);
                    }
                    resource = this.passClient.readResource(resource.getId(), resource.getClass());
                }
                catch (Exception handlerE) {
                    return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(updateResult, resource, false, handlerE);
                }
            }
            catch (Exception e) {
                return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(updateResult, resource, false, e);
            }
            try {
                if (!postcondition.test(resource, updateResult)) {
                    LOG.debug("Postcondition over resource {} and result {} failed.", (Object)resource.getId(), updateResult);
                    return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(updateResult, resource, false);
                }
            }
            catch (Exception e) {
                return new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(updateResult, resource, false, e);
            }
            cr = new CriticalRepositoryInteraction.CriticalResult<Object, PassEntity>(updateResult, resource, true);
        }
        return cr;
    }
}

