/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.support.messaging.cri;

import java.net.URI;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dataconservancy.pass.model.PassEntity;

public interface CriticalRepositoryInteraction {
    public <R, T extends PassEntity> CriticalResult<R, T> performCritical(URI var1, Class<T> var2, Predicate<T> var3, Predicate<T> var4, Function<T, R> var5);

    public <R, T extends PassEntity> CriticalResult<R, T> performCritical(URI var1, Class<T> var2, Predicate<T> var3, BiPredicate<T, R> var4, Function<T, R> var5);

    public static class CriticalResult<R, T> {
        private R result;
        private T resource;
        private boolean success;
        private Throwable t;

        public CriticalResult(R result, T resource, boolean success) {
            this(result, resource, success, null);
        }

        public CriticalResult(R result, T resource, boolean success, Throwable t) {
            this.result = result;
            this.resource = resource;
            this.success = success;
            this.t = t;
        }

        public Optional<T> resource() {
            return Optional.ofNullable(this.resource);
        }

        public Optional<R> result() {
            return Optional.ofNullable(this.result);
        }

        public boolean success() {
            return this.success;
        }

        public Optional<Throwable> throwable() {
            return Optional.ofNullable(this.t);
        }
    }
}

