/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.client.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dataconservancy.pass.model.Deposit;
import org.dataconservancy.pass.model.RepositoryCopy;
import org.dataconservancy.pass.model.Submission;
import org.dataconservancy.pass.model.SubmissionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionStatusCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(SubmissionStatusCalculator.class);

    public static Submission.SubmissionStatus calculatePostSubmissionStatus(List<URI> repositories, List<Deposit> deposits, List<RepositoryCopy> repositoryCopies) {
        if (repositories == null) {
            repositories = new ArrayList<URI>();
        }
        if (deposits == null) {
            deposits = new ArrayList<Deposit>();
        }
        if (repositoryCopies == null) {
            repositoryCopies = new ArrayList<RepositoryCopy>();
        }
        Map<URI, Submission.SubmissionStatus> statusMap = SubmissionStatusCalculator.mapPostSubmissionRepositoryStatuses(repositories, deposits, repositoryCopies);
        return SubmissionStatusCalculator.calculateFromStatusMap(statusMap);
    }

    public static Submission.SubmissionStatus calculatePreSubmissionStatus(List<SubmissionEvent> submissionEvents, Submission.SubmissionStatus defaultStatus) {
        if (submissionEvents == null) {
            submissionEvents = new ArrayList<SubmissionEvent>();
        }
        if (submissionEvents.size() > 0) {
            SubmissionEvent.EventType mostRecentEventType = Collections.max(submissionEvents, Comparator.comparing(SubmissionEvent::getPerformedDate)).getEventType();
            return SubmissionStatusCalculator.mapEventTypeToSubmissionStatus(mostRecentEventType);
        }
        if (defaultStatus == null) {
            return Submission.SubmissionStatus.MANUSCRIPT_REQUIRED;
        }
        return defaultStatus;
    }

    public static void validateStatusChange(boolean submitted, Submission.SubmissionStatus fromStatus, Submission.SubmissionStatus toStatus) {
        if (toStatus == null) {
            throw new IllegalArgumentException("The new status cannot be null");
        }
        if (submitted) {
            if (!toStatus.isSubmitted()) {
                String msg = String.format("Failed to validate the change of status due to conflicting data. The status `%s` cannot be assigned to a Submission that has not yet been submitted. There may be a data issue.", fromStatus);
                throw new RuntimeException(msg);
            }
        } else {
            if (toStatus.isSubmitted()) {
                String msg = String.format("Failed to validate the change of status due to conflicting data. The status `%s` cannot be assigned to a Submission that has already been submitted. There may be a data issue.", fromStatus);
                throw new RuntimeException(msg);
            }
            if (fromStatus != null && fromStatus.isSubmitted()) {
                String msg = String.format("Failed to validate the change of status due to conflicting data. The current status of the Submission is `%s`. This indicates that the Submission was already submitted and therefore should not be assigned a pre-submission status. There may be a data issue.", fromStatus);
                throw new RuntimeException(msg);
            }
            if (fromStatus != null && !toStatus.equals((Object)fromStatus)) {
                LOG.warn("The current status of the Submission conflicts with the status calculated based on the most recent SubmissionEvent. The status on the Submission record is `{}`, while the calculated status is `{}`. The UI is responsible for setting pre-Submission statuses, but this mismatch may indicate a data issue.", (Object)fromStatus, (Object)toStatus);
            }
        }
    }

    private static Submission.SubmissionStatus calculateFromStatusMap(Map<URI, Submission.SubmissionStatus> submissionRepositoryStatusMap) {
        HashSet<Submission.SubmissionStatus> statuses = new HashSet<Submission.SubmissionStatus>(submissionRepositoryStatusMap.values());
        if (statuses.contains(Submission.SubmissionStatus.NEEDS_ATTENTION)) {
            return Submission.SubmissionStatus.NEEDS_ATTENTION;
        }
        if (statuses.size() == 1 && statuses.contains(Submission.SubmissionStatus.COMPLETE)) {
            return Submission.SubmissionStatus.COMPLETE;
        }
        return Submission.SubmissionStatus.SUBMITTED;
    }

    private static Map<URI, Submission.SubmissionStatus> mapPostSubmissionRepositoryStatuses(List<URI> repositories, List<Deposit> deposits, List<RepositoryCopy> repoCopies) {
        HashMap<URI, Submission.SubmissionStatus> statusMap = new HashMap<URI, Submission.SubmissionStatus>();
        for (URI repositoryUri : repositories) {
            statusMap.put(repositoryUri, null);
        }
        for (Deposit d : deposits) {
            if (Deposit.DepositStatus.REJECTED.equals((Object)d.getDepositStatus())) {
                statusMap.put(d.getRepository(), Submission.SubmissionStatus.NEEDS_ATTENTION);
                continue;
            }
            statusMap.put(d.getRepository(), Submission.SubmissionStatus.SUBMITTED);
        }
        for (RepositoryCopy rc : repoCopies) {
            URI repoId = rc.getRepository();
            RepositoryCopy.CopyStatus copyStatus = rc.getCopyStatus();
            if (RepositoryCopy.CopyStatus.COMPLETE.equals((Object)copyStatus)) {
                statusMap.put(repoId, Submission.SubmissionStatus.COMPLETE);
                continue;
            }
            if (RepositoryCopy.CopyStatus.REJECTED.equals((Object)copyStatus) || RepositoryCopy.CopyStatus.STALLED.equals((Object)copyStatus)) {
                statusMap.put(repoId, Submission.SubmissionStatus.NEEDS_ATTENTION);
                continue;
            }
            statusMap.put(repoId, Submission.SubmissionStatus.SUBMITTED);
        }
        return statusMap;
    }

    private static Submission.SubmissionStatus mapEventTypeToSubmissionStatus(SubmissionEvent.EventType eventType) {
        switch (eventType) {
            case APPROVAL_REQUESTED: {
                return Submission.SubmissionStatus.APPROVAL_REQUESTED;
            }
            case APPROVAL_REQUESTED_NEWUSER: {
                return Submission.SubmissionStatus.APPROVAL_REQUESTED;
            }
            case SUBMITTED: {
                return Submission.SubmissionStatus.SUBMITTED;
            }
            case CANCELLED: {
                return Submission.SubmissionStatus.CANCELLED;
            }
            case CHANGES_REQUESTED: {
                return Submission.SubmissionStatus.CHANGES_REQUESTED;
            }
        }
        return null;
    }
}

