/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dataconservancy.pass.client.PassClient;
import org.dataconservancy.pass.client.PassClientFactory;
import org.dataconservancy.pass.client.util.SubmissionStatusCalculator;
import org.dataconservancy.pass.model.Deposit;
import org.dataconservancy.pass.model.PassEntity;
import org.dataconservancy.pass.model.PassEntityType;
import org.dataconservancy.pass.model.RepositoryCopy;
import org.dataconservancy.pass.model.Submission;
import org.dataconservancy.pass.model.SubmissionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionStatusService {
    private static final Logger LOG = LoggerFactory.getLogger(SubmissionStatusService.class);
    private static final String SUBMISSION_MAP_KEY = "submission";
    private static final String PUBLICATION_MAP_KEY = "publication";
    private PassClient client;

    public SubmissionStatusService() {
        this.client = PassClientFactory.getPassClient();
    }

    public SubmissionStatusService(PassClient client) {
        if (client == null) {
            throw new IllegalArgumentException("PassClient cannot be null");
        }
        this.client = client;
    }

    public Submission.SubmissionStatus calculateSubmissionStatus(URI submissionId) {
        Submission submission = this.loadSubmission(submissionId);
        return this.calculateSubmissionStatus(submission);
    }

    public Submission.SubmissionStatus calculateSubmissionStatus(Submission submission) {
        Submission.SubmissionStatus toStatus;
        if (submission == null) {
            throw new IllegalArgumentException("submission cannot be null");
        }
        if (submission.getId() == null) {
            throw new IllegalArgumentException("No status could be calculated for the Submission as it does not have a `Submission.id`.");
        }
        URI submissionId = submission.getId();
        boolean submitted = submission.getSubmitted();
        Submission.SubmissionStatus fromStatus = submission.getSubmissionStatus();
        Collection<URI> submissionLinks = this.retrieveLinks(submissionId, SUBMISSION_MAP_KEY);
        if (!submitted) {
            List<SubmissionEvent> submissionEvents = this.getConnectedRecords(submissionLinks, PassEntityType.SUBMISSION_EVENT, SubmissionEvent.class);
            toStatus = SubmissionStatusCalculator.calculatePreSubmissionStatus(submissionEvents);
        } else {
            List<Deposit> deposits = this.getConnectedRecords(submissionLinks, PassEntityType.DEPOSIT, Deposit.class);
            Collection<URI> publicationLinks = this.retrieveLinks(submission.getPublication(), PUBLICATION_MAP_KEY);
            List<RepositoryCopy> repositoryCopies = this.getConnectedRecords(publicationLinks, PassEntityType.REPOSITORY_COPY, RepositoryCopy.class);
            toStatus = SubmissionStatusCalculator.calculatePostSubmissionStatus(submission.getRepositories(), deposits, repositoryCopies);
        }
        try {
            SubmissionStatusCalculator.validateStatusChange(submitted, fromStatus, toStatus);
        }
        catch (RuntimeException ex) {
            String msg = String.format("Cannot change status from %s to %s on Submission %s. The following explaination was provided: %s", fromStatus, toStatus, submissionId, ex.getMessage());
            throw new RuntimeException(msg);
        }
        return toStatus;
    }

    public Submission.SubmissionStatus calculateAndUpdateSubmissionStatus(URI submissionId) {
        return this.calculateAndUpdateSubmissionStatus(submissionId, false);
    }

    public Submission.SubmissionStatus calculateAndUpdateSubmissionStatus(URI submissionId, boolean overrideUIStatus) {
        Submission submission = this.loadSubmission(submissionId);
        Submission.SubmissionStatus fromStatus = submission.getSubmissionStatus();
        Submission.SubmissionStatus toStatus = this.calculateSubmissionStatus(submission);
        if (fromStatus == null || !fromStatus.equals((Object)toStatus)) {
            if (!overrideUIStatus && !submission.getSubmitted().booleanValue() && fromStatus != null) {
                LOG.info("Status of Submission {} did not change because pre-submission UI statuses are protected. The current status will stay as `{}`", (Object)submission.getId(), (Object)fromStatus);
                return fromStatus;
            }
            submission.setSubmissionStatus(toStatus);
            LOG.info("Updating status of Submission {} from `{}` to `{}`", new Object[]{submission.getId(), fromStatus, toStatus});
            this.client.updateResource((PassEntity)submission);
        } else {
            LOG.debug("Status of Submission {} did not change. The current status is `{}`", (Object)submission.getId(), (Object)fromStatus);
        }
        return toStatus;
    }

    private Submission loadSubmission(URI submissionId) {
        if (submissionId == null) {
            throw new IllegalArgumentException("submissionId cannot be null");
        }
        Submission submission = null;
        try {
            submission = (Submission)this.client.readResource(submissionId, Submission.class);
        }
        catch (Exception ex) {
            String msg = String.format("Failed to retrieve Submission with ID %s from the database", submissionId);
            throw new RuntimeException(msg);
        }
        return submission;
    }

    private Collection<URI> retrieveLinks(URI uri, String mapKey) {
        Collection<URI> links = new HashSet<URI>();
        if (uri == null || mapKey == null) {
            return links;
        }
        Map linksMap = this.client.getIncoming(uri);
        if (linksMap.containsKey(mapKey)) {
            links = (Collection)linksMap.get(mapKey);
        }
        return links;
    }

    private <T extends PassEntity> List<T> getConnectedRecords(Collection<URI> links, PassEntityType entityType, Class<T> modelClass) {
        if (links == null || entityType == null || modelClass == null) {
            return new ArrayList();
        }
        return links.stream().filter(link -> link.toString().contains(entityType.getPlural())).map(res -> this.client.readResource(res, modelClass)).collect(Collectors.toList());
    }
}

