/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.notification;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import javax.mail.Message;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.dataconservancy.pass.client.PassClient;
import org.dataconservancy.pass.client.PassClientDefault;
import org.dataconservancy.pass.model.PassEntity;
import org.dataconservancy.pass.model.Submission;
import org.dataconservancy.pass.model.SubmissionEvent;
import org.dataconservancy.pass.model.User;
import org.dataconservancy.pass.notification.MailUtil;
import org.dataconservancy.pass.notification.SimpleImapClientFactory;
import org.dataconservancy.pass.notification.impl.ComposerIT;
import org.dataconservancy.pass.notification.model.Link;
import org.dataconservancy.pass.notification.util.PathUtil;
import org.dataconservancy.pass.notification.util.async.Condition;
import org.dataconservancy.pass.notification.util.mail.SimpleImapClient;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationSmokeIT {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationSmokeIT.class);
    private static final String SENDER = "noreply@pass.jh.edu";
    private static final String RECIPIENT = "staffWithNoGrants@jhu.edu";
    private static final String CC = "notification-demo-cc@jhu.edu";
    private static final String BCC = "notification-demo-bcc@jhu.edu";
    private PassClient passClient;
    private OkHttpClient httpClient;
    private String contextUri;
    private SimpleImapClientFactory imapClientFactory;
    private SimpleImapClient imapClient;

    @Before
    public void setUp() throws Exception {
        this.passClient = this.passClient();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().authenticator((route, res) -> {
            if (res.request().header("Authorization") != null) {
                return null;
            }
            Assert.assertTrue((boolean)System.getProperties().containsKey("pass.fedora.user"));
            Assert.assertTrue((boolean)System.getProperties().containsKey("pass.fedora.password"));
            String credential = Credentials.basic((String)System.getProperty("pass.fedora.user", "fedoraAdmin"), (String)System.getProperty("pass.fedora.password", "moo"));
            return res.request().newBuilder().header("Authorization", credential).build();
        });
        this.httpClient = builder.build();
        this.contextUri = System.getProperty("pass.jsonld.context", "https://oa-pass.github.io/pass-data-model/src/main/resources/context-3.4.jsonld");
        MailUtil mailUtil = new MailUtil();
        this.imapClientFactory = new SimpleImapClientFactory(mailUtil.mailSession());
        this.imapClientFactory.setImapUser(mailUtil.getImapUser());
        this.imapClientFactory.setImapPass(mailUtil.getImapPass());
        this.imapClient = this.imapClientFactory.getObject();
    }

    @After
    public void tearDown() throws Exception {
        this.imapClient.close();
    }

    @Test
    public void readContext34submissionResource() throws Exception {
        LOG.info("Using JSON-LD context uri {} when creating resources.", (Object)this.contextUri);
        String fedoraBaseUrl = System.getProperty("pass.fedora.baseurl", "http://localhost:8080/fcrepo/rest");
        String repositories = "{\n  \"@id\" : \"\",\n  \"@type\" : \"Repository\",\n  \"agreementText\" : \"NON-EXCLUSIVE LICENSE FOR USE OF MATERIALS This non-exclusive license defines the terms for the deposit of Materials in all formats into the digital repository of materials collected, preserved and made available through the Johns Hopkins Digital Repository, JScholarship. The Contributor hereby grants to Johns Hopkins a royalty free, non-exclusive worldwide license to use, re-use, display, distribute, transmit, publish, re-publish or copy the Materials, either digitally or in print, or in any other medium, now or hereafter known, for the purpose of including the Materials hereby licensed in the collection of materials in the Johns Hopkins Digital Repository for educational use worldwide. In some cases, access to content may be restricted according to provisions established in negotiation with the copyright holder. This license shall not authorize the commercial use of the Materials by Johns Hopkins or any other person or organization, but such Materials shall be restricted to non-profit educational use. Persons may apply for commercial use by contacting the copyright holder. Copyright and any other intellectual property right in or to the Materials shall not be transferred by this agreement and shall remain with the Contributor, or the Copyright holder if different from the Contributor. Other than this limited license, the Contributor or Copyright holder retains all rights, title, copyright and other interest in the images licensed. If the submission contains material for which the Contributor does not hold copyright, the Contributor represents that s/he has obtained the permission of the Copyright owner to grant Johns Hopkins the rights required by this license, and that such third-party owned material is clearly identified and acknowledged within the text or content of the submission. If the submission is based upon work that has been sponsored or supported by an agency or organization other than Johns Hopkins, the Contributor represents that s/he has fulfilled any right of review or other obligations required by such contract or agreement. Johns Hopkins will not make any alteration, other than as allowed by this license, to your submission. This agreement embodies the entire agreement of the parties. No modification of this agreement shall be of any effect unless it is made in writing and signed by all of the parties to the agreement.\",\n  \"formSchema\" : \"{\\\"id\\\":\\\"JScholarship\\\",\\\"schema\\\":{\\\"title\\\":\\\"Johns Hopkins - JScholarship <br><p class='lead text-muted'>Deposit requirements for JH's institutional repository JScholarship.</p>\\\",\\\"type\\\":\\\"object\\\",\\\"properties\\\":{\\\"authors\\\":{\\\"title\\\":\\\"<div class='row'><div class='col-6'>Author(s) <small class='text-muted'>(required)</small></div><div class='col-6 p-0'></div></div>\\\",\\\"type\\\":\\\"array\\\",\\\"uniqueItems\\\":true,\\\"items\\\":{\\\"type\\\":\\\"object\\\",\\\"properties\\\":{\\\"author\\\":{\\\"type\\\":\\\"string\\\",\\\"fieldClass\\\":\\\"body-text col-6 pull-left pl-0\\\"}}}}}},\\\"options\\\":{\\\"fields\\\":{\\\"authors\\\":{\\\"hidden\\\":false}}}}\",\n  \"integrationType\" : \"full\",\n  \"name\" : \"JScholarship\",\n  \"repositoryKey\" : \"jscholarship\",\n  \"schemas\" : [ \"https://oa-pass.github.io/metadata-schemas/jhu/common.json\", \"https://oa-pass.github.io/metadata-schemas/jhu/jscholarship.json\" ],\n  \"url\" : \"https://jscholarship.library.jhu.edu/\",\n  \"@context\" : \"" + this.contextUri + "\"\n}";
        String repositoriesUri = this.createResource(fedoraBaseUrl, "repositories", repositories);
        String policy = "{\n  \"@id\" : \"\",\n  \"@type\" : \"Policy\",\n  \"description\" : \"The university expects that every scholarly article produced by full-time faculty members be accessible in an open access repository. This can be achieved through deposits into existing public access repositories (such as PubMed Central, arXiv, etc.) and/or into Johns Hopkins institutional repository, JScholarship.\",\n  \"policyUrl\" : \"https://provost.jhu.edu/about/open-access/\",\n  \"repositories\" : [ \"" + repositoriesUri + "\" ],\n  \"title\" : \"Johns Hopkins University (JHU) Open Access Policy\",\n  \"@context\" : \"" + this.contextUri + "\"\n}";
        String policyUri = this.createResource(fedoraBaseUrl, "policies", policy);
        String preparers = "{\n  \"@id\" : \"\",\n  \"@type\" : \"User\",\n  \"displayName\" : \"Robin Sinn\",\n  \"email\" : \"rsinn@jhu.edu\",\n  \"locatorIds\" : [ \"johnshopkins.edu:hopkinsid:EGPUI7\", \"johnshopkins.edu:jhed:rsinn1\", \"johnshopkins.edu:employeeid:00019042\" ],\n  \"roles\" : [ \"submitter\" ],\n  \"username\" : \"rsinn1@johnshopkins.edu\",\n  \"@context\" : \"" + this.contextUri + "\"\n}";
        String preparersUri = this.createResource(fedoraBaseUrl, "users", preparers);
        String journal = "{\n  \"@id\" : \"\",\n  \"@type\" : \"Journal\",\n  \"issns\" : [ \"Online:1538-3598\", \"Print:0098-7484\" ],\n  \"journalName\" : \"JAMA\",\n  \"nlmta\" : \"JAMA\",\n  \"@context\" : \"" + this.contextUri + "\"\n}";
        String journalUri = this.createResource(fedoraBaseUrl, "journals", journal);
        String title = "The Urgency and Challenge of Opening K-12 Schools in the Fall of 2020";
        String publication = "{\n  \"@id\" : \"\",\n  \"@type\" : \"Publication\",\n  \"doi\" : \"10.1001/jama.2020.10175\",\n  \"journal\" : \"" + journalUri + "\",\n  \"title\" : \"" + title + "\",\n  \"@context\" : \"" + this.contextUri + "\"\n}";
        String publicationUri = this.createResource(fedoraBaseUrl, "publications", publication);
        String submitter = "{\n  \"@id\" : \"\",\n  \"@type\" : \"User\",\n  \"displayName\" : \"Josh Sharfstein\",\n  \"email\" : \"staffWithNoGrants@jhu.edu\",\n  \"firstName\" : \"Josh\",\n  \"lastName\" : \"Sharfstein\",\n  \"locatorIds\" : [ \"johnshopkins.edu:jhed:jsharfs1\", \"johnshopkins.edu:employeeid:00071462\", \"johnshopkins.edu:hopkinsid:53KS2I\" ],\n  \"roles\" : [ \"submitter\" ],\n  \"@context\" : \"" + this.contextUri + "\"\n}";
        String submitterUri = this.createResource(fedoraBaseUrl, "users", submitter);
        String submission = "{\n  \"@id\" : \"\",\n  \"@type\" : \"Submission\",\n  \"aggregatedDepositStatus\" : \"not-started\",\n  \"effectivePolicies\" : [ \"" + policyUri + "\" ],\n  \"metadata\" : \"{\\\"hints\\\":{\\\"collection-tags\\\":[\\\"covid\\\"]},\\\"publisher\\\":\\\"American Medical Association (AMA)\\\",\\\"title\\\":\\\"" + title + "\\\",\\\"journal-title\\\":\\\"JAMA\\\",\\\"issns\\\":[{\\\"issn\\\":\\\"0098-7484\\\",\\\"pubType\\\":\\\"Print\\\"},{\\\"issn\\\":\\\"1538-3598\\\",\\\"pubType\\\":\\\"Online\\\"}],\\\"authors\\\":[{\\\"author\\\":\\\"Joshua M. Sharfstein\\\"},{\\\"author\\\":\\\"Christopher C. Morphew\\\"}],\\\"journal-NLMTA-ID\\\":\\\"JAMA\\\",\\\"publicationDate\\\":\\\"2020-6-1\\\",\\\"doi\\\":\\\"10.1001/jama.2020.10175\\\",\\\"$schema\\\":\\\"https://oa-pass.github.com/metadata-schemas/jhu/global.json\\\",\\\"agent_information\\\":{\\\"name\\\":\\\"Chrome\\\",\\\"version\\\":\\\"81\\\"}}\",\n  \"preparers\" : [ \"" + preparersUri + "\" ],\n  \"publication\" : \"" + publicationUri + "\",\n  \"repositories\" : [ \"" + repositoriesUri + "\" ],\n  \"source\" : \"pass\",\n  \"submissionStatus\" : \"approval-requested\",\n  \"submitted\" : false,\n  \"submitter\" : \"" + submitterUri + "\",\n  \"@context\" : \"" + this.contextUri + "\"\n}";
        String submissionUri = this.createResource(fedoraBaseUrl, "submissions", submission);
        SubmissionEvent event = new SubmissionEvent();
        event.setSubmission(URI.create(submissionUri));
        event.setPerformerRole(SubmissionEvent.PerformerRole.PREPARER);
        event.setPerformedBy(URI.create(preparersUri));
        String comment = "How does this submission look?";
        event.setComment(comment);
        event.setEventType(SubmissionEvent.EventType.APPROVAL_REQUESTED);
        event.setPerformedDate(DateTime.now());
        Link link = new Link(URI.create(submissionUri.replace("http://localhost", "https://pass.local")), "submission-review");
        event.setLink(link.getHref());
        event = (SubmissionEvent)this.passClient.createAndReadResource((PassEntity)event, SubmissionEvent.class);
        Assert.assertNotNull((Object)event);
        HeaderTerm term = new HeaderTerm("X-PASS-Submission-ID", submissionUri);
        Condition.newSearchMessageCondition((SearchTerm)term, (SimpleImapClient)this.imapClient).await();
        Collection messages = (Collection)Condition.searchMessage((SearchTerm)term, (SimpleImapClient)this.imapClient).call();
        Assert.assertNotNull((Object)messages);
        Assert.assertEquals((long)1L, (long)messages.size());
        Message message = (Message)messages.iterator().next();
        String body = SimpleImapClient.getBodyAsText((Message)message);
        Assert.assertTrue((boolean)message.getSubject().contains(title));
        Assert.assertTrue((boolean)message.getSubject().contains("approval"));
        Assert.assertEquals((Object)SENDER, (Object)message.getFrom()[0].toString());
        Assert.assertEquals((Object)CC, (Object)message.getRecipients(Message.RecipientType.CC)[0].toString());
        Assert.assertEquals((Object)RECIPIENT, (Object)message.getRecipients(Message.RecipientType.TO)[0].toString());
        Assert.assertTrue((boolean)body.contains(title));
        Assert.assertTrue((boolean)body.contains("https://pass.local"));
        Assert.assertFalse((boolean)body.contains("?userToken="));
        Assert.assertTrue((boolean)body.contains(submissionUri.substring(submissionUri.lastIndexOf("/"))));
        Assert.assertTrue((boolean)body.contains(comment));
    }

    @Test
    public void postNewEvent() throws Exception {
        User preparer = new User();
        preparer.setEmail("emetsger@gmail.com");
        preparer.setDisplayName("Submission Preparer");
        preparer.setFirstName("Pre");
        preparer.setLastName("Parer");
        preparer.setRoles(Collections.singletonList(User.Role.SUBMITTER));
        preparer = (User)this.passClient.createAndReadResource((PassEntity)preparer, User.class);
        Submission submission = new Submission();
        submission.setMetadata(IOUtils.resourceToString((String)("/" + PathUtil.packageAsPath(ComposerIT.class) + "/submission-metadata.json"), (Charset)Charset.forName("UTF-8")));
        submission.setPreparers(Collections.singletonList(preparer.getId()));
        submission.setSource(Submission.Source.PASS);
        submission.setSubmitter(null);
        submission.setSubmitterEmail(URI.create("mailto:staffWithNoGrants@jhu.edu"));
        submission = (Submission)this.passClient.createAndReadResource((PassEntity)submission, Submission.class);
        SubmissionEvent event = new SubmissionEvent();
        event.setSubmission(submission.getId());
        event.setPerformerRole(SubmissionEvent.PerformerRole.PREPARER);
        event.setPerformedBy(preparer.getId());
        String comment = "How does this submission look?";
        event.setComment(comment);
        event.setEventType(SubmissionEvent.EventType.APPROVAL_REQUESTED_NEWUSER);
        event.setPerformedDate(DateTime.now());
        String submissionUri = submission.getId().toString();
        Link link = new Link(URI.create(submissionUri.replace("http://localhost", "https://pass.local")), "submission-review-invite");
        event.setLink(link.getHref());
        event = (SubmissionEvent)this.passClient.createAndReadResource((PassEntity)event, SubmissionEvent.class);
        Assert.assertNotNull((Object)event);
        HeaderTerm term = new HeaderTerm("X-PASS-Submission-ID", submissionUri);
        Condition.newSearchMessageCondition((SearchTerm)term, (SimpleImapClient)this.imapClient).await();
        Collection messages = (Collection)Condition.searchMessage((SearchTerm)term, (SimpleImapClient)this.imapClient).call();
        Assert.assertNotNull((Object)messages);
        Assert.assertEquals((long)1L, (long)messages.size());
        Message message = (Message)messages.iterator().next();
        String body = SimpleImapClient.getBodyAsText((Message)message);
        Assert.assertTrue((boolean)message.getSubject().contains("Specific protein supplementation using soya"));
        Assert.assertTrue((boolean)message.getSubject().contains("approval"));
        Assert.assertEquals((Object)SENDER, (Object)message.getFrom()[0].toString());
        Assert.assertEquals((Object)CC, (Object)message.getRecipients(Message.RecipientType.CC)[0].toString());
        Assert.assertEquals((Object)RECIPIENT, (Object)message.getRecipients(Message.RecipientType.TO)[0].toString());
        Assert.assertTrue((boolean)body.contains("https://pass.local"));
        Assert.assertTrue((boolean)body.contains("?userToken="));
        Assert.assertTrue((boolean)body.contains(submissionUri.substring(submissionUri.lastIndexOf("/"))));
        Assert.assertTrue((boolean)body.contains(comment));
    }

    @Test
    public void verifyBcc() throws Exception {
        User preparer = new User();
        preparer.setEmail(RECIPIENT);
        preparer.setDisplayName("Submission Preparer");
        preparer.setFirstName("Pre");
        preparer.setLastName("Parer");
        preparer.setRoles(Collections.singletonList(User.Role.SUBMITTER));
        preparer = (User)this.passClient.createAndReadResource((PassEntity)preparer, User.class);
        User submitter = new User();
        submitter.setEmail("staffWithGrants@jhu.edu");
        submitter.setDisplayName("Submission Submitter");
        submitter.setFirstName("Authorized");
        submitter.setLastName("Submitter");
        submitter.setRoles(Collections.singletonList(User.Role.SUBMITTER));
        submitter = (User)this.passClient.createAndReadResource((PassEntity)submitter, User.class);
        Submission submission = new Submission();
        submission.setMetadata(IOUtils.resourceToString((String)("/" + PathUtil.packageAsPath(ComposerIT.class) + "/submission-metadata.json"), (Charset)Charset.forName("UTF-8")));
        submission.setPreparers(Collections.singletonList(preparer.getId()));
        submission.setSource(Submission.Source.PASS);
        submission.setSubmitter(submitter.getId());
        submission = (Submission)this.passClient.createAndReadResource((PassEntity)submission, Submission.class);
        SubmissionEvent event = new SubmissionEvent();
        event.setSubmission(submission.getId());
        event.setPerformerRole(SubmissionEvent.PerformerRole.PREPARER);
        event.setPerformedBy(preparer.getId());
        String comment = "BCC Test";
        event.setComment(comment);
        event.setEventType(SubmissionEvent.EventType.APPROVAL_REQUESTED);
        event.setPerformedDate(DateTime.now());
        Link link = new Link(URI.create(submission.getId().toString().replace("http://localhost", "https://pass.local")), "submission-review");
        event.setLink(link.getHref());
        event = (SubmissionEvent)this.passClient.createAndReadResource((PassEntity)event, SubmissionEvent.class);
        Assert.assertNotNull((Object)event);
        String submissionUri = submission.getId().toString();
        this.imapClientFactory.setImapUser(BCC);
        this.imapClientFactory.setImapPass("moo");
        try (SimpleImapClient bccImapClient = this.imapClientFactory.getObject();){
            HeaderTerm term = new HeaderTerm("X-PASS-Submission-ID", submissionUri);
            Condition.newSearchMessageCondition((SearchTerm)term, (SimpleImapClient)bccImapClient).await();
            Collection messages = (Collection)Condition.searchMessage((SearchTerm)term, (SimpleImapClient)bccImapClient).call();
            Assert.assertNotNull((Object)messages);
            Assert.assertEquals((long)1L, (long)messages.size());
            Message message = (Message)messages.iterator().next();
            String body = SimpleImapClient.getBodyAsText((Message)message);
            Assert.assertTrue((boolean)message.getSubject().contains("Specific protein supplementation using soya"));
            Assert.assertTrue((boolean)message.getSubject().contains("approval"));
            Assert.assertEquals((Object)SENDER, (Object)message.getFrom()[0].toString());
            Assert.assertEquals((Object)"staffWithGrants@jhu.edu", (Object)message.getRecipients(Message.RecipientType.TO)[0].toString());
            Assert.assertTrue((boolean)body.contains("https://pass.local"));
            Assert.assertTrue((boolean)body.contains(submissionUri.substring(submissionUri.lastIndexOf("/"))));
            Assert.assertTrue((boolean)body.contains(comment));
        }
    }

    private PassClientDefault passClient() {
        Assert.assertTrue((boolean)System.getProperties().containsKey("pass.fedora.user"));
        Assert.assertTrue((boolean)System.getProperties().containsKey("pass.fedora.password"));
        Assert.assertTrue((boolean)System.getProperties().containsKey("pass.fedora.baseurl"));
        Assert.assertTrue((boolean)System.getProperties().containsKey("pass.elasticsearch.url"));
        Assert.assertTrue((boolean)System.getProperties().containsKey("pass.elasticsearch.limit"));
        Assert.assertTrue((boolean)System.getProperties().containsKey("http.agent"));
        return new PassClientDefault();
    }

    private String createResource(String fedoraBaseUrl, String container, String json) throws IOException {
        String resultUri;
        String postUrl = fedoraBaseUrl.endsWith("/") ? fedoraBaseUrl + container : fedoraBaseUrl + "/" + container;
        try (Response res = this.httpClient.newCall(new Request.Builder().header("Content-Type", "application/ld+json").post(RequestBody.create((MediaType)MediaType.parse((String)"application/ld+json"), (String)json)).url(postUrl).build()).execute();){
            Assert.assertTrue((boolean)res.isSuccessful());
            resultUri = res.header("Location");
            Assert.assertNotNull((Object)resultUri);
        }
        return resultUri;
    }
}

