/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.notification.aop.logging;

import java.util.Collections;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.dataconservancy.pass.notification.dispatch.DispatchException;
import org.dataconservancy.pass.notification.model.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LoggingAspect {
    private static final Logger NOTIFICATION_LOG = LoggerFactory.getLogger((String)"NOTIFICATION_LOG");

    @Pointcut(value="execution(public * org.dataconservancy.pass.notification.dispatch.DispatchService.dispatch(..))")
    void dispatchApiMethod() {
    }

    @Before(value="dispatchApiMethod()")
    public void logNotification(JoinPoint jp) {
        Object[] args = jp.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        Notification n = (Notification)args[0];
        NOTIFICATION_LOG.debug("Dispatching notification to [{}], cc [{}] (Notification type: {}, Event URI: {}, Resource URI: {})", new Object[]{String.join((CharSequence)",", Optional.ofNullable(n.getRecipients()).orElseGet(Collections::emptyList)), String.join((CharSequence)",", Optional.ofNullable(n.getCc()).orElseGet(Collections::emptyList)), n.getType(), n.getEventUri(), n.getResourceUri()});
    }

    @AfterReturning(pointcut="dispatchApiMethod()", returning="id")
    public void logNotificationReturn(JoinPoint jp, String id) {
        Object[] args = jp.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        Notification n = (Notification)args[0];
        NOTIFICATION_LOG.info("Successfully dispatched notification with id {} to [{}], cc [{}] (Notification type: {}, Event URI: {}, Resource URI: {})", new Object[]{id, String.join((CharSequence)",", Optional.ofNullable(n.getRecipients()).orElseGet(Collections::emptyList)), String.join((CharSequence)",", Optional.ofNullable(n.getCc()).orElseGet(Collections::emptyList)), n.getType(), n.getEventUri(), n.getResourceUri()});
    }

    @AfterThrowing(pointcut="dispatchApiMethod()", throwing="ex")
    public void logNotificationError(Throwable ex) {
        Notification n;
        if (ex instanceof DispatchException && (n = ((DispatchException)ex).getNotification()) != null) {
            NOTIFICATION_LOG.warn("FAILED dispatching notification to [{}], cc [{}] (Notification type: {}, Event URI: {}, Resource URI: {})", new Object[]{String.join((CharSequence)",", Optional.ofNullable(n.getRecipients()).orElseGet(Collections::emptyList)), String.join((CharSequence)",", Optional.ofNullable(n.getCc()).orElseGet(Collections::emptyList)), n.getType(), n.getEventUri(), n.getResourceUri(), ex});
            return;
        }
        NOTIFICATION_LOG.warn("FAILED dispatching notification", ex);
    }
}

