/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.loader.nihms.util;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dataconservancy.pass.loader.nihms.util.ConfigUtil;

public class FileUtil {
    private static final String NIHMS_DATA_DIR_PROPKEY = "nihmsetl.data.dir";
    private static final String DEFAULT_DATA_FOLDER = "/data";
    private static Predicate<Path> FILTER_GENERAL = path -> {
        PathMatcher pathFilter = p -> true;
        String filterProp = ConfigUtil.getSystemProperty("filter", null);
        if (filterProp != null) {
            pathFilter = FileSystems.getDefault().getPathMatcher("glob:" + filterProp);
        }
        return pathFilter.matches(path.getFileName());
    };
    private static Predicate<Path> FILTER_CSV = path -> path.getFileName().toString().endsWith(".csv");

    public static String getCurrentDirectory() {
        try {
            return new File(FileUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static File getConfigFilePath(String filepathKey, String defaultFileName) {
        String configFilePath = ConfigUtil.getSystemProperty(filepathKey, FileUtil.getCurrentDirectory() + "/" + defaultFileName);
        File configDirectory = new File(configFilePath);
        return configDirectory;
    }

    public static File getDataDirectory() {
        String currDirectoryPath = FileUtil.getCurrentDirectory();
        String dataFilePath = ConfigUtil.getSystemProperty(NIHMS_DATA_DIR_PROPKEY, FileUtil.getCurrentDirectory() + "/" + DEFAULT_DATA_FOLDER);
        if (dataFilePath == null) {
            dataFilePath = currDirectoryPath + DEFAULT_DATA_FOLDER;
        }
        File downloadDirectory = new File(dataFilePath);
        return downloadDirectory;
    }

    public static List<Path> getCsvFilePaths(Path directory) {
        List<Path> filepaths = null;
        try {
            filepaths = Files.list(directory).filter(FILTER_GENERAL).filter(FILTER_CSV).map(Path::toAbsolutePath).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new RuntimeException("A problem occurred while loading CSV file paths from " + directory.toString());
        }
        return filepaths;
    }

    public static void renameToDone(Path path) {
        File file = path.toFile();
        file.renameTo(new File(file.getAbsolutePath() + ".done"));
    }
}

