/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.loader.nihms.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;

public class ConfigUtil {
    private static final String NIHMS_REPOSITORY_URI_KEY = "nihmsetl.repository.uri";
    private static final String NIHMS_REPOSITORY_URI_DEFAULT = "https://example.com/fedora/repositories/1";

    public static String getSystemProperty(String key, String defaultValue) {
        return System.getProperty(key, System.getenv().getOrDefault(ConfigUtil.toEnvName(key), defaultValue));
    }

    static String toEnvName(String name) {
        return name.toUpperCase().replace('.', '_');
    }

    public static URI getNihmsRepositoryUri() {
        try {
            return new URI(ConfigUtil.getSystemProperty(NIHMS_REPOSITORY_URI_KEY, NIHMS_REPOSITORY_URI_DEFAULT));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("NIHMS repository property is not a valid URI, please check the nihms.pass.uri property is populated correctly.", e);
        }
    }

    public static Properties loadProperties(File propertiesFile) {
        String resource;
        Properties properties = new Properties();
        try {
            resource = propertiesFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open configuration file, check configuration path.", e);
        }
        try (FileInputStream resourceStream = new FileInputStream(resource);){
            properties.load(resourceStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open configuration file, check configuration path.", e);
        }
        return properties;
    }
}

