/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.jhu.library.pass.deposit.provider.bagit.BagItPackageVerifier;
import edu.jhu.library.pass.deposit.provider.integration.SpringContextConfiguration;
import edu.jhu.library.pass.deposit.provider.j10p.DspaceMetsPackageVerifier;
import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.dataconservancy.pass.deposit.assembler.PackageOptions;
import org.dataconservancy.pass.deposit.assembler.shared.ExplodedPackage;
import org.dataconservancy.pass.deposit.assembler.shared.PackageVerifier;
import org.dataconservancy.pass.deposit.integration.shared.SubmitAndValidatePackagesIT;
import org.dataconservancy.pass.deposit.model.DepositSubmission;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsPackageVerifier;
import org.dataconservancy.pass.model.Repository;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={SpringContextConfiguration.class})
public class ValidateDspaceAndNihmsProvidersIT
extends SubmitAndValidatePackagesIT {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateDspaceAndNihmsProvidersIT.class);
    private DspaceMetsPackageVerifier dspaceVerifier;
    private NihmsPackageVerifier nihmsVerifier;
    private BagItPackageVerifier bagitVerifier;

    @Before
    public void setUp() throws Exception {
        this.dspaceVerifier = new DspaceMetsPackageVerifier(PackageOptions.Checksum.OPTS.SHA512);
        this.nihmsVerifier = new NihmsPackageVerifier();
        this.bagitVerifier = new BagItPackageVerifier();
        Set existingRepos = this.passClient.findAllByAttribute(Repository.class, "repositoryKey", (Object)"*").stream().map(uri -> (Repository)this.passClient.readResource(uri, Repository.class)).map(Repository::getRepositoryKey).collect(Collectors.toSet());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(((Object)((Object)this)).getClass().getResourceAsStream("/repositories.json"));
        node.fieldNames().forEachRemaining(repoKey -> {
            if (!existingRepos.contains(repoKey)) {
                System.out.println("Dynamically creating Repository with key '" + repoKey + "'");
                Repository repo = new Repository();
                repo.setRepositoryKey(repoKey);
                repo.setDescription("Dynamically created by " + ((Object)((Object)this)).getClass().getName());
                repo.setName("Dynamic " + repoKey);
                existingRepos.add(repoKey);
            }
        });
    }

    protected PackageVerifier getVerifier(DepositSubmission depositSubmission, ExplodedPackage explodedPackage) {
        if (explodedPackage.getPackageFile().toString().contains("pmc")) {
            return this.nihmsVerifier;
        }
        if (explodedPackage.getPackageFile().toString().contains("jscholarship")) {
            return this.dspaceVerifier;
        }
        if (explodedPackage.getPackageFile().toString().contains("bagit")) {
            return this.bagitVerifier;
        }
        Assert.fail((String)"Unable to select PackageVerifier");
        return null;
    }

    protected PackageOptions.Compression.OPTS sniffCompression(File packageFile) {
        return PackageOptions.Compression.OPTS.NONE;
    }

    protected PackageOptions.Archive.OPTS sniffArchive(File packageFile) {
        return PackageOptions.Archive.OPTS.ZIP;
    }
}

