/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.integration;

import org.dataconservancy.pass.client.PassClientDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringContextConfiguration {
    @Value(value="${pass.fedora.user}")
    private String fedoraUser;
    @Value(value="${pass.fedora.password}")
    private String fedoraPass;
    @Value(value="${pass.fedora.baseurl}")
    private String fedoraBaseUrl;
    @Value(value="${pass.elasticsearch.url}")
    private String esUrl;
    @Value(value="${pass.elasticsearch.limit}")
    private int esLimit;
    @Value(value="${pass.deposit.http.agent}")
    private String passHttpAgent;
    @Value(value="${pass.jsonld.context}")
    private String contextUri;

    @Bean
    public PassClientDefault passClient() {
        if (!System.getProperties().containsKey("pass.fedora.user")) {
            System.setProperty("pass.fedora.user", this.fedoraUser);
        }
        if (!System.getProperties().containsKey("pass.fedora.password")) {
            System.setProperty("pass.fedora.password", this.fedoraPass);
        }
        if (!System.getProperties().containsKey("pass.fedora.baseurl")) {
            System.setProperty("pass.fedora.baseurl", this.fedoraBaseUrl);
        }
        if (!System.getProperties().containsKey("pass.elasticsearch.url")) {
            System.setProperty("pass.elasticsearch.url", this.esUrl);
        }
        if (!System.getProperties().containsKey("pass.elasticsearch.limit")) {
            System.setProperty("pass.elasticsearch.limit", String.valueOf(this.esLimit));
        }
        if (!System.getProperties().containsKey("http.agent")) {
            System.setProperty("http.agent", this.passHttpAgent);
        }
        return new PassClientDefault();
    }
}

