/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dataconservancy.pass.deposit.assembler.shared.SizedStream;
import org.dataconservancy.pass.deposit.model.DepositFile;
import org.dataconservancy.pass.deposit.model.DepositFileType;
import org.dataconservancy.pass.deposit.model.DepositManifest;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsAssemblerUtil;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsPackageProvider;
import org.dataconservancy.pass.deposit.provider.nihms.StreamingSerializer;

public class NihmsManifestSerializer
implements StreamingSerializer {
    static final String METADATA_ENTRY_NAME = "bulk_meta.xml";
    static final String MANIFEST_ENTRY_NAME = "manifest.txt";
    private DepositManifest manifest;

    public NihmsManifestSerializer(DepositManifest manifest) {
        this.manifest = manifest;
    }

    @Override
    public SizedStream serialize() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(os);
        DepositFileLabelMaker labelMaker = new DepositFileLabelMaker();
        for (DepositFile file : this.manifest.getFiles()) {
            writer.write(file.getType().toString());
            writer.append("\t");
            String label = labelMaker.getTypeUniqueLabel(file.getType(), file.getLabel());
            if (label != null) {
                writer.write(label);
            }
            writer.append("\t");
            String name = NihmsPackageProvider.getNonCollidingFilename(file.getName(), file.getType());
            writer.write(name);
            writer.append("\n");
        }
        if (this.manifest.getFiles().stream().noneMatch(df -> df.getType() == DepositFileType.bulksub_meta_xml)) {
            NihmsManifestSerializer.includeBulkMetadataInManifest(writer, labelMaker);
        }
        writer.close();
        return NihmsAssemblerUtil.asSizedStream(os);
    }

    protected static void includeBulkMetadataInManifest(PrintWriter writer, DepositFileLabelMaker labelMaker) {
        writer.write(DepositFileType.bulksub_meta_xml.name());
        writer.append("\t");
        writer.write(labelMaker.getTypeUniqueLabel(DepositFileType.bulksub_meta_xml, "Submission Metadata"));
        writer.append("\t");
        writer.write(METADATA_ENTRY_NAME);
    }

    class DepositFileLabelMaker {
        private final DepositFileType[] requiredLabelTypes = new DepositFileType[]{DepositFileType.figure, DepositFileType.table, DepositFileType.supplement};
        private final Set<DepositFileType> requiredTypes = new HashSet<DepositFileType>(Arrays.asList(this.requiredLabelTypes));
        private Map<DepositFileType, Set<String>> usedFileLabels = this.createLabelMap();

        DepositFileLabelMaker() {
        }

        private Map<DepositFileType, Set<String>> createLabelMap() {
            HashMap<DepositFileType, Set<String>> labelMap = new HashMap<DepositFileType, Set<String>>();
            for (DepositFileType fileType : Arrays.asList(DepositFileType.values())) {
                labelMap.put(fileType, new HashSet());
            }
            return labelMap;
        }

        String getTypeUniqueLabel(DepositFileType type, String description) {
            int i;
            String firstTry;
            String label;
            boolean missing = false;
            if (description == null || description.replaceAll("\\s", "").length() == 0) {
                description = "";
            }
            if ((label = description.replaceAll("\t", " ").trim()).length() == 0) {
                if (this.requiredTypes.contains(type)) {
                    label = type.toString();
                    missing = true;
                } else {
                    return "";
                }
            }
            String string = firstTry = missing ? label + "-1" : label;
            if (!this.usedFileLabels.get(type).contains(firstTry)) {
                this.usedFileLabels.get(type).add(firstTry);
                return firstTry;
            }
            int n = i = missing ? 2 : 1;
            while (this.usedFileLabels.get(type).contains(label + "-" + Integer.toString(i))) {
                ++i;
            }
            label = label + "-" + Integer.toString(i);
            this.usedFileLabels.get(type).add(label);
            return label;
        }
    }
}

