/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dataconservancy.pass.deposit.assembler.MetadataBuilder;
import org.dataconservancy.pass.deposit.assembler.PackageStream;
import org.dataconservancy.pass.deposit.assembler.shared.AbstractAssembler;
import org.dataconservancy.pass.deposit.assembler.shared.ArchivingPackageStream;
import org.dataconservancy.pass.deposit.assembler.shared.AssemblerSupport;
import org.dataconservancy.pass.deposit.assembler.shared.DepositFileResource;
import org.dataconservancy.pass.deposit.assembler.shared.Extension;
import org.dataconservancy.pass.deposit.assembler.shared.MetadataBuilderFactory;
import org.dataconservancy.pass.deposit.assembler.shared.PackageProvider;
import org.dataconservancy.pass.deposit.assembler.shared.ResourceBuilderFactory;
import org.dataconservancy.pass.deposit.model.DepositSubmission;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsPackageProvider;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsPackageProviderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NihmsAssembler
extends AbstractAssembler {
    public static final String SPEC_NIHMS_NATIVE_2017_07 = "nihms-native-2017-07";
    public static final String APPLICATION_GZIP = "application/gzip";
    public static final String BULK_META_FILENAME = "bulk_meta.xml";
    public static final String MANIFEST_FILENAME = "manifest.txt";
    private static final String PACKAGE_FILE_NAME = "%s_%s_%s";
    private NihmsPackageProviderFactory packageProviderFactory;

    @Autowired
    public NihmsAssembler(MetadataBuilderFactory mbf, ResourceBuilderFactory rbf, NihmsPackageProviderFactory packageProviderFactory) {
        super(mbf, rbf);
        this.packageProviderFactory = packageProviderFactory;
    }

    protected PackageStream createPackageStream(DepositSubmission submission, List<DepositFileResource> custodialResources, MetadataBuilder mb, ResourceBuilderFactory rbf, Map<String, Object> options) {
        AssemblerSupport.buildMetadata((MetadataBuilder)mb, options);
        NihmsAssembler.namePackage(submission, mb);
        NihmsPackageProvider packageProvider = this.packageProviderFactory.newInstance();
        return new ArchivingPackageStream(submission, custodialResources, mb, rbf, options, (PackageProvider)packageProvider);
    }

    static void namePackage(DepositSubmission submission, MetadataBuilder mb) {
        String submissionUuid = null;
        try {
            URI submissionUri = URI.create(submission.getId());
            submissionUuid = submissionUri.getPath().substring(submissionUri.getPath().lastIndexOf("/") + 1);
        }
        catch (Exception e) {
            submissionUuid = UUID.randomUUID().toString();
        }
        String packageFileName = String.format(PACKAGE_FILE_NAME, SPEC_NIHMS_NATIVE_2017_07, ZonedDateTime.now().format(DateTimeFormatter.ofPattern("uuuu-MM-dd_HH-MM-ss")), submissionUuid);
        StringBuilder ext = new StringBuilder(packageFileName);
        PackageStream.Metadata md = mb.build();
        if (md.archived()) {
            switch (md.archive()) {
                case TAR: {
                    ext.append(".").append(Extension.TAR.getExt());
                    break;
                }
                case ZIP: {
                    ext.append(".").append(Extension.ZIP.getExt());
                }
            }
        }
        if (md.compressed()) {
            switch (md.compression()) {
                case BZIP2: {
                    ext.append(".").append(Extension.BZ2.getExt());
                    break;
                }
                case GZIP: {
                    ext.append(".").append(Extension.GZ.getExt());
                }
            }
        }
        mb.name(NihmsAssembler.sanitizeFilename((String)ext.toString()));
    }
}

