/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.dataconservancy.pass.deposit.DepositTestUtil;
import org.dataconservancy.pass.deposit.assembler.PackageOptions;
import org.dataconservancy.pass.deposit.assembler.PackageStream;
import org.dataconservancy.pass.deposit.assembler.shared.AbstractAssembler;
import org.dataconservancy.pass.deposit.assembler.shared.BaseAssemblerIT;
import org.dataconservancy.pass.deposit.model.DepositFile;
import org.dataconservancy.pass.deposit.model.DepositFileType;
import org.dataconservancy.pass.deposit.model.DepositMetadata;
import org.dataconservancy.pass.deposit.model.JournalPublicationType;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsAssembler;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsPackageProvider;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsPackageProviderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NihmsAssemblerIT
extends BaseAssemblerIT {
    private File manifest;
    private File metadata;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.manifest = new File(this.extractedPackageDir, "manifest.txt");
        this.metadata = new File(this.extractedPackageDir, "bulk_meta.xml");
    }

    protected Map<String, Object> getOptions() {
        return new HashMap<String, Object>(){
            {
                this.put("SPEC", "nihms-native-2017-07");
                this.put("ARCHIVE", PackageOptions.Archive.OPTS.TAR);
                this.put("COMPRESSION", PackageOptions.Compression.OPTS.GZIP);
            }
        };
    }

    @Test
    public void testSimple() throws Exception {
        Assert.assertTrue((boolean)this.extractedPackageDir.exists());
    }

    protected AbstractAssembler assemblerUnderTest() {
        NihmsPackageProviderFactory packageProviderFactory = new NihmsPackageProviderFactory();
        return new NihmsAssembler(this.mbf, this.rbf, packageProviderFactory);
    }

    protected void verifyStreamMetadata(PackageStream.Metadata metadata) {
        Assert.assertEquals((Object)PackageOptions.Compression.OPTS.GZIP, (Object)metadata.compression());
        Assert.assertEquals((Object)PackageOptions.Archive.OPTS.TAR, (Object)metadata.archive());
        Assert.assertTrue((boolean)metadata.archived());
        Assert.assertEquals((Object)"nihms-native-2017-07", (Object)metadata.spec());
        Assert.assertEquals((Object)"application/gzip", (Object)metadata.mimeType());
    }

    @Test
    public void testBasicStructure() throws Exception {
        Assert.assertTrue((String)("Missing NIHMS package manifest (expected: " + this.manifest + ")"), (boolean)this.manifest.exists());
        Assert.assertTrue((String)("Missing NIHMS bulk metadata (expected: " + this.metadata + ")"), (boolean)this.metadata.exists());
        Assert.assertTrue((String)"Expected Files to be attached to the DepositSubmission!", (this.submission.getFiles().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected exactly 1 manuscript to be attached to the DepositSubmission!", (this.submission.getFiles().stream().filter(df -> df.getType() == DepositFileType.manuscript).count() == 1L ? 1 : 0) != 0);
        Map<String, DepositFileType> custodialResourcesTypeMap = this.custodialResources.stream().collect(Collectors.toMap(DepositFile::getName, DepositFile::getType));
        this.custodialResources.forEach(custodialResource -> {
            String filename = NihmsPackageProvider.getNonCollidingFilename((String)custodialResource.getName(), (DepositFileType)custodialResource.getType());
            Assert.assertTrue((boolean)this.extractedPackageDir.toPath().resolve(filename).toFile().exists());
        });
        Map packageFiles = Arrays.stream(this.extractedPackageDir.listFiles()).collect(Collectors.toMap(File::getName, Function.identity()));
        packageFiles.keySet().stream().filter(fileName -> !fileName.equals(this.manifest.getName()) && !fileName.equals(this.metadata.getName())).forEach(fileName -> {
            String remediatedFilename = NihmsPackageProvider.getNonCollidingFilename((String)fileName, (DepositFileType)((DepositFileType)custodialResourcesTypeMap.get(fileName)));
            if (!remediatedFilename.startsWith("SUBMISSION-")) {
                Assert.assertTrue((String)("Missing file from custodial resources: '" + remediatedFilename + "'"), (boolean)this.custodialResourcesMap.containsKey(remediatedFilename));
            } else {
                Assert.assertTrue((String)("Missing remediated file from custodial resources: '" + remediatedFilename + "'"), (boolean)this.custodialResourcesMap.containsKey(remediatedFilename.substring("SUBMISSION-".length())));
            }
        });
        Assert.assertTrue((boolean)packageFiles.keySet().contains(this.manifest.getName()));
        Assert.assertTrue((boolean)packageFiles.keySet().contains(this.metadata.getName()));
    }

    @Test
    public void testPackageManifest() throws Exception {
        int lineCount = 0;
        LineIterator lines = FileUtils.lineIterator((File)this.manifest);
        ArrayList<String> entries = new ArrayList<String>();
        while (lines.hasNext()) {
            String line = lines.nextLine();
            entries.add(line);
            new ManifestLine(this.manifest, line, lineCount++).assertAll();
        }
        Assert.assertEquals((String)("Expected one line per custodial resource plus metadata file in NIHMS manifest file " + this.manifest), (long)(this.submission.getFiles().size() + 1), (long)lineCount);
        HashMap labels = new HashMap();
        for (DepositFileType fileType : Arrays.asList(DepositFileType.values())) {
            labels.put(fileType.toString(), new HashSet());
        }
        for (String entry : entries) {
            String[] fields = entry.split("\t");
            Assert.assertFalse((boolean)((Set)labels.get(fields[0])).contains(fields[1]));
            if (!fields[0].equals("figure") && !fields[0].equals("table") && !fields[0].equals("supplement")) continue;
            Assert.assertTrue((fields[1].length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPackageMetadata() throws Exception {
        Document metaDom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.metadata);
        Assert.assertNotNull((Object)metaDom);
        Element root = metaDom.getDocumentElement();
        Assert.assertEquals((Object)"nihms-submit", (Object)root.getTagName());
        Element title = (Element)DepositTestUtil.asList((NodeList)root.getElementsByTagName("title")).get(0);
        Assert.assertEquals((Object)this.submission.getMetadata().getManuscriptMetadata().getTitle(), (Object)title.getTextContent());
        List personElements = DepositTestUtil.asList((NodeList)root.getElementsByTagName("person"));
        Assert.assertEquals((long)1L, (long)personElements.size());
        List asPersons = personElements.stream().map(element -> {
            DepositMetadata.Person asPerson = new DepositMetadata.Person();
            asPerson.setFirstName(element.getAttribute("fname"));
            asPerson.setLastName(element.getAttribute("lname"));
            asPerson.setMiddleName(element.getAttribute("mname"));
            asPerson.setType(DepositMetadata.PERSON_TYPE.submitter);
            return asPerson;
        }).collect(Collectors.toList());
        asPersons.stream().forEach(person -> Assert.assertTrue((boolean)this.submission.getMetadata().getPersons().stream().anyMatch(candidate -> candidate.getConstructedName().equals(person.getName()) && candidate.getType() == person.getType())));
        Element ms = (Element)DepositTestUtil.asList((NodeList)root.getElementsByTagName("manuscript")).get(0);
        Assert.assertEquals((Object)this.submission.getMetadata().getArticleMetadata().getDoi().toString(), (Object)ms.getAttribute("doi"));
        List issns = DepositTestUtil.asList((NodeList)root.getElementsByTagName("issn"));
        Map issnPubTypes = this.submission.getMetadata().getJournalMetadata().getIssnPubTypes();
        Assert.assertEquals((long)issnPubTypes.size(), (long)issns.size());
        Assert.assertTrue((issnPubTypes.size() > 0 ? 1 : 0) != 0);
        issns.forEach(issn -> Assert.assertTrue((boolean)issnPubTypes.containsKey(issn.getTextContent())));
        issns.forEach(issn -> {
            DepositMetadata.IssnPubType pubType = (DepositMetadata.IssnPubType)issnPubTypes.get(issn.getTextContent());
            if (pubType.pubType == JournalPublicationType.OPUB) {
                Assert.assertEquals((Object)issn.getAttribute("pub-type"), (Object)JournalPublicationType.EPUB.name().toLowerCase());
            } else {
                Assert.assertEquals((Object)issn.getAttribute("pub-type"), (Object)pubType.pubType.name().toLowerCase());
            }
        });
    }

    @Test
    public void rereadIOutilsStringInputStream() throws IOException {
        String expected = "This is the manifest.";
        InputStream in = IOUtils.toInputStream((String)"This is the manifest.", (String)"UTF-8");
        Assert.assertEquals((Object)"This is the manifest.", (Object)IOUtils.toString((InputStream)in, (String)"UTF-8"));
        Assert.assertEquals((Object)"", (Object)IOUtils.toString((InputStream)in, (String)"UTF-8"));
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static class ManifestLine {
        private static final String ERR = "File %s, line %s is missing %s";
        private File manifestFile;
        private String line;
        private int lineNo;

        private ManifestLine(File manifestFile, String line, int lineNo) {
            this.manifestFile = manifestFile;
            this.line = line;
            this.lineNo = lineNo;
        }

        void assertAll() {
            this.assertTypeIsPresent();
            this.assertLabelIsPresent();
            this.assertFileIsPresent();
            this.assertNameIsValid();
        }

        void assertTypeIsPresent() {
            String[] parts = this.line.split("\t");
            try {
                Assert.assertFalse((String)String.format(ERR, this.manifestFile, this.lineNo, "a file type"), (boolean)NihmsAssemblerIT.isNullOrEmpty(parts[0]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Assert.fail((String)String.format(ERR, this.manifestFile, this.lineNo, "a file type"));
            }
        }

        void assertLabelIsPresent() {
            String[] parts = this.line.split("\t");
            try {
                Assert.assertFalse((String)String.format(ERR, this.manifestFile, this.lineNo, "a file label"), (boolean)NihmsAssemblerIT.isNullOrEmpty(parts[1]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Assert.fail((String)String.format(ERR, this.manifestFile, this.lineNo, "a file label"));
            }
        }

        void assertFileIsPresent() {
            String[] parts = this.line.split("\t");
            try {
                Assert.assertFalse((String)String.format(ERR, this.manifestFile, this.lineNo, "a file name"), (boolean)NihmsAssemblerIT.isNullOrEmpty(parts[2]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Assert.fail((String)String.format(ERR, this.manifestFile, this.lineNo, "a file name"));
            }
        }

        void assertNameIsValid() {
            Assert.assertFalse((String)String.format("File %s, line %s: Name cannot be same as metadata file.", this.manifestFile, this.lineNo), (this.manifestFile.getName() == "bulk_meta.xml" ? 1 : 0) != 0);
            Assert.assertFalse((String)String.format("File %s, line %s: Name cannot be same as manifest file.", this.manifestFile, this.lineNo), (this.manifestFile.getName() == "manifest.txt" ? 1 : 0) != 0);
        }
    }
}

