/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dataconservancy.pass.deposit.assembler.PackageStream;
import org.dataconservancy.pass.deposit.assembler.shared.DepositFileResource;
import org.dataconservancy.pass.deposit.assembler.shared.PackageProvider;
import org.dataconservancy.pass.deposit.assembler.shared.SizedStream;
import org.dataconservancy.pass.deposit.model.DepositFileType;
import org.dataconservancy.pass.deposit.model.DepositSubmission;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsManifestSerializer;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsMetadataSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class NihmsPackageProvider
implements PackageProvider {
    static final String REMEDIATED_FILE_PREFIX = "SUBMISSION-";
    private static final Logger LOG = LoggerFactory.getLogger(NihmsPackageProvider.class);
    private NihmsManifestSerializer manifestSerializer;
    private NihmsMetadataSerializer metadataSerializer;

    public static String getNonCollidingFilename(String fileName, DepositFileType fileType) {
        if (fileName.contentEquals("bulk_meta.xml") && fileType != DepositFileType.bulksub_meta_xml || fileName.contentEquals("manifest.txt")) {
            fileName = REMEDIATED_FILE_PREFIX + fileName;
        }
        return fileName;
    }

    public void start(DepositSubmission submission, List<DepositFileResource> custodialResources, Map<String, Object> packageOptions) {
        this.manifestSerializer = new NihmsManifestSerializer(submission.getManifest());
        this.metadataSerializer = new NihmsMetadataSerializer(submission.getMetadata());
    }

    public String packagePath(DepositFileResource custodialResource) {
        String candidateName = custodialResource.getDepositFile() != null && custodialResource.getDepositFile().getName() != null ? custodialResource.getDepositFile().getName() : custodialResource.getFilename();
        String packagePath = NihmsPackageProvider.getNonCollidingFilename(candidateName, custodialResource.getDepositFile().getType());
        LOG.trace("Pathed {} as {}", (Object)custodialResource, (Object)packagePath);
        return packagePath;
    }

    public List<PackageProvider.SupplementalResource> finish(DepositSubmission submission, List<PackageStream.Resource> packageResources) {
        ArrayList<PackageProvider.SupplementalResource> supplementalResources = new ArrayList<PackageProvider.SupplementalResource>(2);
        SizedStream manifestStream = this.manifestSerializer.serialize();
        SizedStream metadataStream = this.metadataSerializer.serialize();
        supplementalResources.add(new NihmsSupplementalResource("manifest.txt", "manifest.txt", manifestStream.getLength(), manifestStream.getInputStream(), "NIHMS Manifest"));
        supplementalResources.add(new NihmsSupplementalResource("bulk_meta.xml", "bulk_meta.xml", metadataStream.getLength(), metadataStream.getInputStream(), "NIMS Metadata"));
        return supplementalResources;
    }

    private class NihmsSupplementalResource
    implements PackageProvider.SupplementalResource {
        private String packagePath;
        private String name;
        private long length;
        private InputStream byteStream;
        private String description;

        public NihmsSupplementalResource(String packagePath, String name, long length, InputStream byteStream, String description) {
            this.packagePath = packagePath;
            this.name = name;
            this.length = length;
            this.byteStream = byteStream;
            this.description = description;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public boolean exists() {
            return false;
        }

        public URL getURL() throws IOException {
            throw new IOException("Resource only exists in memory, and has no descriptor.");
        }

        public URI getURI() throws IOException {
            throw new IOException("Resource only exists in memory, and has no descriptor.");
        }

        public File getFile() throws IOException {
            throw new IOException("Resource only exists in memory, and has no descriptor.");
        }

        public long contentLength() throws IOException {
            return this.length;
        }

        public long lastModified() throws IOException {
            return System.currentTimeMillis();
        }

        public Resource createRelative(String relativePath) throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getFilename() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public InputStream getInputStream() throws IOException {
            return this.byteStream;
        }

        public String toString() {
            return this.description;
        }
    }
}

