/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.dataconservancy.pass.deposit.assembler.shared.SizedStream;
import org.dataconservancy.pass.deposit.model.DepositMetadata;
import org.dataconservancy.pass.deposit.model.JournalPublicationType;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsAssemblerUtil;
import org.dataconservancy.pass.deposit.provider.nihms.StreamingSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NihmsMetadataSerializer
implements StreamingSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(NihmsMetadataSerializer.class);
    private DepositMetadata metadata;

    public NihmsMetadataSerializer(DepositMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public SizedStream serialize() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("_-", "_")));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        xstream.registerConverter((Converter)new MetadataConverter());
        xstream.alias("nihms-submit", DepositMetadata.class);
        xstream.toXML((Object)this.metadata, (OutputStream)os);
        return NihmsAssemblerUtil.asSizedStream(os);
    }

    String booleanConvert(boolean b) {
        return b ? "yes" : "no";
    }

    private class MetadataConverter
    implements Converter {
        private MetadataConverter() {
        }

        public boolean canConvert(Class clazz) {
            return DepositMetadata.class == clazz;
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            List persons;
            DepositMetadata.Journal journal;
            DepositMetadata metadata = (DepositMetadata)value;
            DepositMetadata.Manuscript manuscript = metadata.getManuscriptMetadata();
            DepositMetadata.Article article = metadata.getArticleMetadata();
            if (manuscript != null) {
                writer.startNode("manuscript");
                if (manuscript.getNihmsId() != null) {
                    writer.addAttribute("id", manuscript.getNihmsId());
                }
                writer.addAttribute("publisher_pdf", NihmsMetadataSerializer.this.booleanConvert(manuscript.isPublisherPdf()));
                writer.addAttribute("show_publisher_pdf", NihmsMetadataSerializer.this.booleanConvert(manuscript.isShowPublisherPdf()));
                if (metadata.getArticleMetadata() == null || metadata.getArticleMetadata().getEmbargoLiftDate() != null) {
                    // empty if block
                }
                if (manuscript.getManuscriptUrl() != null) {
                    writer.addAttribute("href", manuscript.getManuscriptUrl().toString());
                }
                if (article != null && article.getDoi() != null) {
                    String path = article.getDoi().getPath();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    writer.addAttribute("doi", path);
                }
                writer.endNode();
            }
            if ((journal = metadata.getJournalMetadata()) != null) {
                writer.startNode("journal-meta");
                if (journal.getJournalId() != null) {
                    writer.startNode("journal-id");
                    if (journal.getJournalType() != null) {
                        writer.addAttribute("journal-id-type", journal.getJournalType());
                    }
                    writer.setValue(journal.getJournalId());
                    writer.endNode();
                }
                journal.getIssnPubTypes().values().forEach(issnPubType -> {
                    if (issnPubType.pubType == null || issnPubType.issn == null || issnPubType.issn.trim().isEmpty()) {
                        LOG.debug("Discarding incomplete ISSN: {}", issnPubType);
                        return;
                    }
                    writer.startNode("issn");
                    if (issnPubType.pubType == JournalPublicationType.OPUB) {
                        writer.addAttribute("pub-type", JournalPublicationType.EPUB.name().toLowerCase());
                    } else {
                        writer.addAttribute("pub-type", issnPubType.pubType.name().toLowerCase());
                    }
                    writer.setValue(issnPubType.issn);
                    writer.endNode();
                });
                if (journal.getJournalTitle() != null) {
                    writer.startNode("journal-title");
                    writer.setValue(journal.getJournalTitle());
                    writer.endNode();
                }
                writer.endNode();
            }
            if (manuscript != null && manuscript.getTitle() != null) {
                writer.startNode("title");
                writer.setValue(manuscript.getTitle());
                writer.endNode();
            }
            if ((persons = metadata.getPersons()) != null && persons.size() > 0) {
                writer.startNode("contacts");
                for (DepositMetadata.Person person : persons) {
                    if (person.getType() != DepositMetadata.PERSON_TYPE.submitter) continue;
                    writer.startNode("person");
                    if (person.getFirstName() != null) {
                        writer.addAttribute("fname", person.getFirstName());
                    } else if (person.getFullName() != null) {
                        writer.addAttribute("fname", person.getFullName().split("\\s")[0]);
                    }
                    if (person.getMiddleName() != null) {
                        writer.addAttribute("mname", person.getMiddleName());
                    }
                    if (person.getLastName() != null) {
                        writer.addAttribute("lname", person.getLastName());
                    } else if (person.getFullName() != null) {
                        String[] split = person.getFullName().split("\\s");
                        if (split.length > 2) {
                            writer.addAttribute("lname", String.join((CharSequence)" ", Arrays.copyOfRange(split, 2, split.length)));
                        } else {
                            writer.addAttribute("lname", split[1]);
                        }
                    }
                    if (person.getEmail() != null) {
                        writer.addAttribute("email", person.getEmail());
                    }
                    writer.addAttribute("corrpi", NihmsMetadataSerializer.this.booleanConvert(true));
                    writer.addAttribute("pi", NihmsMetadataSerializer.this.booleanConvert(true));
                    writer.endNode();
                    break;
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return null;
        }
    }
}

