/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dataconservancy.pass.deposit.assembler.shared.SizedStream;

class NihmsAssemblerUtil {
    NihmsAssemblerUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SizedStream asSizedStream(final ByteArrayOutputStream os) {
        byte[] bytes = os.toByteArray();
        try (final ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            os.close();
            SizedStream sizedStream = new SizedStream(){

                public long getLength() {
                    return os.size();
                }

                public InputStream getInputStream() {
                    return is;
                }
            };
            return sizedStream;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create Input Stream, or close Output Stream", ioe);
        }
    }
}

