/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.dataconservancy.pass.deposit.assembler.shared.ExplodedPackage;
import org.dataconservancy.pass.deposit.assembler.shared.PackageVerifier;
import org.dataconservancy.pass.deposit.model.DepositSubmission;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsManifestSerializer;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsMetadataSerializer;
import org.junit.Assert;

public class NihmsPackageVerifier
implements PackageVerifier {
    public void verify(DepositSubmission submission, ExplodedPackage explodedPackage, Map<String, Object> map) throws Exception {
        IOFileFilter custodialFiles = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.nameFileFilter((String)"bulk_meta.xml"), FileFilterUtils.nameFileFilter((String)"manifest.txt")}));
        this.verifyCustodialFiles(submission, explodedPackage.getExplodedDir(), (FileFilter)custodialFiles, (packageDirectory, file) -> submission.getFiles().stream().filter(df -> df.getName().equals(file.getName())).findAny().orElseThrow(() -> new RuntimeException("Unable to find file " + file + " in the Submission")));
        File bulk_meta = new File(explodedPackage.getExplodedDir(), "bulk_meta.xml");
        File manifest = new File(explodedPackage.getExplodedDir(), "manifest.txt");
        Assert.assertTrue((bulk_meta.exists() && bulk_meta.length() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((manifest.exists() && manifest.length() > 0L ? 1 : 0) != 0);
        String expectedManifest = IOUtils.toString((InputStream)new NihmsManifestSerializer(submission.getManifest()).serialize().getInputStream(), (Charset)StandardCharsets.UTF_8);
        String expectedBulkMeta = IOUtils.toString((InputStream)new NihmsMetadataSerializer(submission.getMetadata()).serialize().getInputStream(), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)expectedManifest, (Object)IOUtils.toString((InputStream)new FileInputStream(manifest), (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((Object)expectedBulkMeta, (Object)IOUtils.toString((InputStream)new FileInputStream(bulk_meta), (Charset)StandardCharsets.UTF_8));
    }
}

