/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import org.dataconservancy.pass.deposit.model.DepositFileType;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsPackageProvider;
import org.junit.Assert;
import org.junit.Test;

public class NihmsPackageProviderTest {
    @Test
    public void nonCollidingFilename() throws Exception {
        String nameIn = "test.txt";
        String nameOut = NihmsPackageProvider.getNonCollidingFilename((String)nameIn, (DepositFileType)DepositFileType.supplement);
        Assert.assertTrue((String)"Non-colliding name was changed.", (boolean)nameIn.contentEquals(nameOut));
        nameIn = "manifest.txt";
        nameOut = NihmsPackageProvider.getNonCollidingFilename((String)nameIn, (DepositFileType)DepositFileType.supplement);
        Assert.assertFalse((String)"Colliding manifest name was not changed.", (boolean)nameIn.contentEquals(nameOut));
        nameIn = "bulk_meta.xml";
        nameOut = NihmsPackageProvider.getNonCollidingFilename((String)nameIn, (DepositFileType)DepositFileType.supplement);
        Assert.assertFalse((String)"Colliding metadata name was not changed.", (boolean)nameIn.contentEquals(nameOut));
        nameIn = "bulk_meta.xml";
        nameOut = NihmsPackageProvider.getNonCollidingFilename((String)nameIn, (DepositFileType)DepositFileType.bulksub_meta_xml);
        Assert.assertTrue((String)"Actual metadata name was changed.", (boolean)nameIn.contentEquals(nameOut));
    }
}

