/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.dataconservancy.pass.deposit.assembler.shared.SizedStream;
import org.dataconservancy.pass.deposit.model.DepositMetadata;
import org.dataconservancy.pass.deposit.model.JournalPublicationType;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsMetadataSerializer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class NihmsMetadataSerializerTest {
    private static NihmsMetadataSerializer underTest;
    private static DepositMetadata metadata;

    @BeforeClass
    public static void setup() throws Exception {
        DepositMetadata.Journal journal = new DepositMetadata.Journal();
        DepositMetadata.Manuscript manuscript = new DepositMetadata.Manuscript();
        DepositMetadata.Article article = new DepositMetadata.Article();
        ArrayList<DepositMetadata.Person> personList = new ArrayList<DepositMetadata.Person>();
        journal.setJournalId("FJ001");
        journal.setJournalTitle("Dairy Cow Monthly");
        journal.setIssnPubTypes((Map)new HashMap<String, DepositMetadata.IssnPubType>(){
            {
                this.put("8765-4321", new DepositMetadata.IssnPubType("8765-4321", JournalPublicationType.EPUB));
                this.put("1234-5678", new DepositMetadata.IssnPubType("1234-5678", JournalPublicationType.OPUB));
                this.put("0000-0000", new DepositMetadata.IssnPubType("0000-0000", JournalPublicationType.PPUB));
            }
        });
        manuscript.setManuscriptUrl(new URL("http://farm.com/Cows"));
        manuscript.setNihmsId("00001");
        manuscript.setPublisherPdf(true);
        manuscript.setShowPublisherPdf(false);
        manuscript.setTitle("Manuscript Title");
        article.setDoi(URI.create("10.1234/smh0000001"));
        DepositMetadata.Person person1 = new DepositMetadata.Person();
        person1.setType(DepositMetadata.PERSON_TYPE.author);
        person1.setEmail("person@farm.com");
        person1.setFirstName("Bessie");
        person1.setLastName("Cow");
        person1.setMiddleName("The");
        personList.add(person1);
        DepositMetadata.Person person1a = new DepositMetadata.Person(person1);
        person1.setType(DepositMetadata.PERSON_TYPE.pi);
        personList.add(person1);
        DepositMetadata.Person person2 = new DepositMetadata.Person();
        person2.setType(DepositMetadata.PERSON_TYPE.submitter);
        person2.setEmail("person@farm.com");
        person2.setFirstName("Elsie");
        person2.setLastName("Cow");
        person2.setMiddleName("The");
        personList.add(person2);
        DepositMetadata.Person person3 = new DepositMetadata.Person();
        person3.setType(DepositMetadata.PERSON_TYPE.author);
        person3.setEmail("person@farm.com");
        person3.setFirstName("Mark");
        person3.setLastName("Cow");
        person3.setMiddleName("The");
        personList.add(person3);
        DepositMetadata.Person person4 = new DepositMetadata.Person();
        person4.setType(DepositMetadata.PERSON_TYPE.copi);
        person4.setEmail("person@farm.com");
        person4.setFirstName("John");
        person4.setLastName("Cow");
        person4.setMiddleName("The");
        personList.add(person4);
        metadata.setJournalMetadata(journal);
        metadata.setManuscriptMetadata(manuscript);
        metadata.setPersons(personList);
        metadata.setArticleMetadata(article);
        underTest = new NihmsMetadataSerializer(metadata);
    }

    @Test
    public void testSerializedMetadataValidity() throws Exception {
        SizedStream sizedStream = underTest.serialize();
        byte[] buffer = new byte[sizedStream.getInputStream().available()];
        sizedStream.getInputStream().read(buffer);
        sizedStream.getInputStream().close();
        File targetFile = new File("MetadataSerializerTest.xml");
        FileOutputStream os = new FileOutputStream(targetFile);
        ((OutputStream)os).write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n".getBytes());
        ((OutputStream)os).write("<!DOCTYPE nihms-submit SYSTEM \"bulksubmission.dtd\">\n".getBytes());
        ((OutputStream)os).write(buffer);
        ((OutputStream)os).close();
        Validator v = Validator.forLanguage((String)"http://www.w3.org/TR/REC-xml");
        StreamSource dtd = new StreamSource(this.getClass().getResourceAsStream("bulksubmission.dtd"));
        dtd.setSystemId(this.getClass().getResource("bulksubmission.dtd").toURI().toString());
        v.setSchemaSource((Source)dtd);
        StreamSource s = new StreamSource("MetadataSerializerTest.xml");
        ValidationResult r = v.validateInstance((Source)s);
        Assert.assertTrue((boolean)r.isValid());
    }

    @Test
    public void testSerializedMetadataDoi() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        String path = "10.1234/smh0000001";
        metadata.getArticleMetadata().setDoi(URI.create(path));
        SizedStream sizedStream = underTest.serialize();
        InputStream is = sizedStream.getInputStream();
        Node node = builder.parse(is).getDocumentElement().getFirstChild().getNextSibling();
        String doi = node.getAttributes().getNamedItem("doi").getTextContent();
        is.close();
        Assert.assertTrue((String)"Valid DOI was modified during export.", (boolean)doi.contentEquals(path));
        metadata.getArticleMetadata().setDoi(URI.create("http://dx.doi.org/" + path));
        sizedStream = underTest.serialize();
        is = sizedStream.getInputStream();
        node = builder.parse(is).getDocumentElement().getFirstChild().getNextSibling();
        doi = node.getAttributes().getNamedItem("doi").getTextContent();
        is.close();
        Assert.assertTrue((String)"http:// prefix and/or domain not stripped from DOI during export.", (boolean)doi.contentEquals(path));
    }

    @Test
    public void completeIssnPubtype() throws IOException, ParserConfigurationException, SAXException {
        DepositMetadata metadata = new DepositMetadata();
        DepositMetadata.Journal journalMd = new DepositMetadata.Journal();
        String expectedIssn = "foo";
        String expectedPubType = JournalPublicationType.EPUB.name().toLowerCase();
        final DepositMetadata.IssnPubType issn = new DepositMetadata.IssnPubType(expectedIssn, JournalPublicationType.OPUB);
        journalMd.setIssnPubTypes((Map)new HashMap<String, DepositMetadata.IssnPubType>(){
            {
                this.put(issn.issn, issn);
            }
        });
        metadata.setJournalMetadata(journalMd);
        underTest = new NihmsMetadataSerializer(metadata);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(underTest.serialize().getInputStream());
        NodeList issnNodes = doc.getElementsByTagName("issn");
        Assert.assertEquals((long)1L, (long)issnNodes.getLength());
        Node actualIssn = NihmsMetadataSerializerTest.asStream(issnNodes).filter(node -> expectedIssn.equals(node.getFirstChild().getNodeValue())).findAny().orElseThrow(() -> new RuntimeException("Missing expected <issn> element for " + expectedIssn + " and " + expectedPubType));
        Assert.assertEquals((Object)expectedPubType, (Object)actualIssn.getAttributes().getNamedItem("pub-type").getNodeValue());
    }

    @Test
    public void incompleteIssnPubtypeNullIssn() throws IOException {
        DepositMetadata metadata = new DepositMetadata();
        DepositMetadata.Journal journalMd = new DepositMetadata.Journal();
        final DepositMetadata.IssnPubType nullIssn = new DepositMetadata.IssnPubType(null, JournalPublicationType.OPUB);
        journalMd.setIssnPubTypes((Map)new HashMap<String, DepositMetadata.IssnPubType>(){
            {
                this.put(nullIssn.issn, nullIssn);
            }
        });
        metadata.setJournalMetadata(journalMd);
        underTest = new NihmsMetadataSerializer(metadata);
        Assert.assertFalse((boolean)IOUtils.toString((InputStream)underTest.serialize().getInputStream(), (Charset)StandardCharsets.UTF_8).contains("issn"));
    }

    @Test
    public void incompleteIssnPubtypeNullPubType() throws IOException {
        DepositMetadata metadata = new DepositMetadata();
        DepositMetadata.Journal journalMd = new DepositMetadata.Journal();
        final DepositMetadata.IssnPubType nullPubType = new DepositMetadata.IssnPubType("foo", null);
        journalMd.setIssnPubTypes((Map)new HashMap<String, DepositMetadata.IssnPubType>(){
            {
                this.put(nullPubType.issn, nullPubType);
            }
        });
        metadata.setJournalMetadata(journalMd);
        underTest = new NihmsMetadataSerializer(metadata);
        Assert.assertFalse((boolean)IOUtils.toString((InputStream)underTest.serialize().getInputStream(), (Charset)StandardCharsets.UTF_8).contains("issn"));
    }

    @Test
    public void missingUserFirstNameAndLastName() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        DepositMetadata.Person submitter = metadata.getPersons().stream().filter(p -> p.getType() == DepositMetadata.PERSON_TYPE.submitter).findAny().orElseThrow(() -> new RuntimeException("Missing Submitter for submission."));
        String expectedFirstName = "MooFirstName";
        String expectedLastName = "CowLastName";
        submitter.setFullName(String.format("%s %s %s", expectedFirstName, "SpotsMiddleName", expectedLastName));
        submitter.setFirstName(null);
        submitter.setLastName(null);
        Element doc = builder.parse(underTest.serialize().getInputStream()).getDocumentElement();
        Node foundPerson = NihmsMetadataSerializerTest.asStream(doc.getElementsByTagName("person")).filter(node -> node.getAttributes().getNamedItem("email").getTextContent().equals(submitter.email)).findAny().orElseThrow(() -> new RuntimeException("Missing submitter person in serialized metadata"));
        Assert.assertEquals((Object)expectedFirstName, (Object)foundPerson.getAttributes().getNamedItem("fname").getTextContent());
        Assert.assertEquals((Object)expectedLastName, (Object)foundPerson.getAttributes().getNamedItem("lname").getTextContent());
    }

    private static Stream<Node> asStream(final NodeList nodeList) {
        int characteristics = 80;
        Stream<Node> nodeStream = StreamSupport.stream(new Spliterators.AbstractSpliterator<Node>((long)nodeList.getLength(), characteristics){
            int index;
            {
                super(x0, x1);
                this.index = 0;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Node> action) {
                if (nodeList.getLength() == this.index) {
                    return false;
                }
                action.accept(nodeList.item(this.index++));
                return true;
            }
        }, false);
        return nodeStream;
    }

    static {
        metadata = new DepositMetadata();
    }
}

