/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.dataconservancy.pass.deposit.assembler.shared.SizedStream;
import org.dataconservancy.pass.deposit.model.DepositFile;
import org.dataconservancy.pass.deposit.model.DepositFileType;
import org.dataconservancy.pass.deposit.model.DepositManifest;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsManifestSerializer;
import org.junit.Assert;
import org.junit.Test;

public class NihmsManifestSerializerTest {
    @Test
    public void testManifestSerialization() {
        DepositManifest manifest = new DepositManifest();
        DepositFile file1 = new DepositFile();
        file1.setLabel("File One Label");
        file1.setName("File One name");
        file1.setType(DepositFileType.figure);
        DepositFile file2 = new DepositFile();
        file2.setLabel("File Two Label");
        file2.setName("File Two name");
        file2.setType(DepositFileType.bulksub_meta_xml);
        DepositFile file3 = new DepositFile();
        file3.setLabel("File Three Label");
        file3.setName("File Three name");
        file3.setType(DepositFileType.table);
        DepositFile file4 = new DepositFile();
        file4.setName("File Four name");
        file4.setType(DepositFileType.manuscript);
        ArrayList<DepositFile> files = new ArrayList<DepositFile>();
        files.add(file1);
        files.add(file2);
        files.add(file3);
        files.add(file4);
        manifest.setFiles(files);
        NihmsManifestSerializer underTest = new NihmsManifestSerializer(manifest);
        SizedStream sizedStream = underTest.serialize();
        String expected = "figure\tFile One Label\tFile One name\nbulksub_meta_xml\tFile Two Label\tFile Two name\ntable\tFile Three Label\tFile Three name\nmanuscript\t\tFile Four name\n";
        String actual = "";
        try {
            actual = IOUtils.toString((InputStream)sizedStream.getInputStream(), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void labelMakerTest() {
        NihmsManifestSerializer underTest = new NihmsManifestSerializer(null);
        NihmsManifestSerializer.DepositFileLabelMaker labelMaker = new NihmsManifestSerializer.DepositFileLabelMaker(underTest);
        String label = labelMaker.getTypeUniqueLabel(DepositFileType.figure, null);
        Assert.assertEquals((Object)"figure-1", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.figure, null);
        Assert.assertEquals((Object)"figure-2", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.figure, "   ");
        Assert.assertEquals((Object)"figure-3", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.supplement, "figure-1");
        Assert.assertEquals((Object)"figure-1", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.supplement, null);
        Assert.assertEquals((Object)"supplement-1", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.supplement, "");
        Assert.assertEquals((Object)"supplement-2", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.supplement, null);
        Assert.assertEquals((Object)"supplement-3", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.manuscript, "Moo Cows in the Pasture");
        Assert.assertEquals((Object)"Moo Cows in the Pasture", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.figure, "Spotted Cows");
        Assert.assertEquals((Object)"Spotted Cows", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.figure, "Spotted Cows");
        Assert.assertEquals((Object)"Spotted Cows-1", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.figure, "Spotted Cows     ");
        Assert.assertEquals((Object)"Spotted Cows-2", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.figure, "Spotted Cows-2");
        Assert.assertEquals((Object)"Spotted Cows-2-1", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.table, "table");
        Assert.assertEquals((Object)"table", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.table, "table-1");
        Assert.assertEquals((Object)"table-1", (Object)label);
        label = labelMaker.getTypeUniqueLabel(DepositFileType.table, "");
        Assert.assertEquals((Object)"table-2", (Object)label);
    }
}

