/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.provider.nihms;

import java.util.UUID;
import org.dataconservancy.pass.deposit.assembler.MetadataBuilder;
import org.dataconservancy.pass.deposit.assembler.PackageOptions;
import org.dataconservancy.pass.deposit.assembler.PackageStream;
import org.dataconservancy.pass.deposit.assembler.shared.Extension;
import org.dataconservancy.pass.deposit.model.DepositSubmission;
import org.dataconservancy.pass.deposit.provider.nihms.NihmsAssembler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NihmsAssemblerTest {
    private static final Logger LOG = LoggerFactory.getLogger(NihmsAssemblerTest.class);
    private DepositSubmission submission;
    private PackageStream.Metadata metadata;
    private MetadataBuilder mdBuilder;
    private String expectedSubmissionUuid;
    ArgumentCaptor<String> packageNameCaptor;

    @Before
    public void setUp() throws Exception {
        this.submission = (DepositSubmission)Mockito.mock(DepositSubmission.class);
        this.metadata = (PackageStream.Metadata)Mockito.mock(PackageStream.Metadata.class);
        this.mdBuilder = (MetadataBuilder)Mockito.mock(MetadataBuilder.class);
        this.expectedSubmissionUuid = UUID.randomUUID().toString();
        Mockito.when((Object)this.submission.getId()).thenReturn((Object)("http://example.org/" + this.expectedSubmissionUuid));
        Mockito.when((Object)this.mdBuilder.build()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.archived()).thenReturn((Object)true);
        Mockito.when((Object)this.metadata.compressed()).thenReturn((Object)true);
        this.packageNameCaptor = ArgumentCaptor.forClass(String.class);
    }

    @Test
    public void packageNameForTarGz() throws Exception {
        Mockito.when((Object)this.metadata.archive()).thenReturn((Object)PackageOptions.Archive.OPTS.TAR);
        Mockito.when((Object)this.metadata.compression()).thenReturn((Object)PackageOptions.Compression.OPTS.GZIP);
        NihmsAssembler.namePackage((DepositSubmission)this.submission, (MetadataBuilder)this.mdBuilder);
        ((MetadataBuilder)Mockito.verify((Object)this.mdBuilder)).name((String)this.packageNameCaptor.capture());
        NihmsAssemblerTest.validatePackageName((String)this.packageNameCaptor.getValue());
    }

    @Test
    public void packageNameForZip() throws Exception {
        Mockito.when((Object)this.metadata.archive()).thenReturn((Object)PackageOptions.Archive.OPTS.ZIP);
        Mockito.when((Object)this.metadata.compression()).thenReturn((Object)PackageOptions.Compression.OPTS.ZIP);
        NihmsAssembler.namePackage((DepositSubmission)this.submission, (MetadataBuilder)this.mdBuilder);
        ((MetadataBuilder)Mockito.verify((Object)this.mdBuilder)).name((String)this.packageNameCaptor.capture());
        NihmsAssemblerTest.validatePackageName((String)this.packageNameCaptor.getValue());
    }

    private static void validatePackageName(String packageName) {
        LOG.debug("Validating NIHMS package name: '{}'", (Object)packageName);
        Assert.assertNotNull((Object)packageName);
        String[] nameParts = packageName.split("\\.");
        for (int i = nameParts.length - 1; i > -1; --i) {
            try {
                Extension.parseExt((String)nameParts[i]);
                continue;
            }
            catch (Exception exception) {
                Assert.assertEquals((long)0L, (long)i);
            }
        }
    }
}

