/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.bagit;

import com.github.jknack.handlebars.Handlebars;
import edu.jhu.library.pass.deposit.provider.bagit.BagModel;
import edu.jhu.library.pass.deposit.provider.bagit.HandlebarsParameterizer;
import edu.jhu.library.pass.deposit.provider.bagit.TestUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.dataconservancy.pass.client.PassClient;
import org.dataconservancy.pass.deposit.model.DepositMetadata;
import org.dataconservancy.pass.deposit.model.DepositSubmission;
import org.dataconservancy.pass.model.Submission;
import org.dataconservancy.pass.model.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HandlebarsParameterizerTest {
    private static final String HBM_TEMPLATE = "Source-Organization: {{sourceOrganization}}\nOrganization-Address: {{organizationAddress}}\nContact-Name: {{contactName}}\nContact-Phone: {{contactEmail}}\nContact-Email: {{contactPhone}}\nExternal-Description: Submitted as {{submissionUri}} to PASS on {{submissionDate}} by {{submissionUserFullName}} ({{submissionUserEmail}}), published as {{publisherId}}\nBagging-Date: {{currentDate}}\nExternal-Identifier: {{publisherId}}\nBag-Size: {{bagSizeHumanReadable}}\nPayload-Oxum: {{custodialFileCount}}.{{bagSizeBytes}}\nInternal-Sender-Identifier: {{submissionUri}}\nInternal-Sender-Description: Submitted as {{submissionUri}} to PASS on {{submissionDate}} by {{submissionUserFullName}} ({{submissionUserEmail}}), published as {{publisherId}}";
    private static final String PUBLICATION_DOI = "10.1039/c7fo01251a";
    private static final String SUBMISSION_METADATA = "{\"doi\": \"10.1039/c7fo01251a\"}";
    private Submission passSubmission;
    private DepositSubmission depositSubmission;
    private User submitter;
    private BagModel model;
    private PassClient passClient;
    private HandlebarsParameterizer underTest;

    @Before
    public void setUp() throws Exception {
        this.underTest = new HandlebarsParameterizer(new Handlebars());
        this.passSubmission = new Submission();
        this.depositSubmission = new DepositSubmission();
        this.submitter = new User();
        this.passSubmission.setId(TestUtil.randomUri());
        this.depositSubmission.setId(this.passSubmission.getId().toString());
        this.submitter.setId(TestUtil.randomUri());
        this.passSubmission.setSubmitter(this.submitter.getId());
        this.passSubmission.setSubmittedDate(DateTime.now());
        this.passSubmission.setMetadata(SUBMISSION_METADATA);
        DepositMetadata depositMetadata = (DepositMetadata)Mockito.mock(DepositMetadata.class);
        DepositMetadata.Article articleMetadata = (DepositMetadata.Article)Mockito.mock(DepositMetadata.Article.class);
        Mockito.when((Object)depositMetadata.getArticleMetadata()).thenReturn((Object)articleMetadata);
        Mockito.when((Object)articleMetadata.getDoi()).thenReturn((Object)URI.create(PUBLICATION_DOI));
        this.depositSubmission.setMetadata(depositMetadata);
        this.submitter.setDisplayName("Joe User");
        this.submitter.setEmail("joeuser@user.com");
        this.model = new BagModel();
        this.model.setSourceOrganization("Johns Hopkins");
        this.model.setOrganizationAddress("3400 N. Charles St, Baltimore, MD 21218");
        this.model.setContactName("Joe Contact");
        this.model.setContactPhone("555-555-5555");
        this.model.setContactEmail("joecontact@jhu.edu");
        this.model.setSubmissionUser(this.submitter);
        this.model.setSubmission(this.passSubmission);
        this.model.setSubmissionDate(ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC().print((ReadableInstant)this.passSubmission.getSubmittedDate()));
        this.model.setSubmissionUserEmail(this.submitter.getEmail());
        this.model.setSubmissionUserUri(this.submitter.getId().toString());
        this.model.setSubmissionUserFullName("Joe User");
        this.model.setPublisherId(PUBLICATION_DOI);
        this.model.setSubmissionUri(this.passSubmission.getId().toString());
        this.model.setBagSizeHumanReadable("15 GiB");
        this.model.setBagSizeBytes(15L * Math.round(Math.pow(2.0, 30.0)));
        this.model.setCustodialFileCount(300L);
        this.model.setBagItVersion("1.0");
        this.model.setDepositSubmission(this.depositSubmission);
        this.model.setSubmissionUserFullName("Joe User");
        this.model.setSubmissionUserEmail("joeuser@user.com");
        this.model.setCurrentDate("2019-05-07");
    }

    @Test
    public void simple() {
        String result = this.underTest.parameterize(IOUtils.toInputStream((String)HBM_TEMPLATE, (Charset)StandardCharsets.UTF_8), this.model);
        System.err.println(result);
    }
}

