/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.bagit;

import edu.jhu.library.pass.deposit.provider.bagit.BagItWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class BagItWriterTest {
    @Test
    public void validateLabelSuccess() {
        BagItWriter.validateLabel((String)"foo");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelCr() {
        BagItWriter.validateLabel((String)"foo\r");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelLf() {
        BagItWriter.validateLabel((String)"foo\n");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelColon() {
        BagItWriter.validateLabel((String)"foo:bar");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelCrLf() {
        BagItWriter.validateLabel((String)"foo\r\n");
    }

    @Test
    public void validateLabelContainsSpace() {
        BagItWriter.validateLabel((String)"f o o");
    }

    @Test
    public void validateLabelContainsTab() {
        BagItWriter.validateLabel((String)"f    o   o");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelStartsWithTab() {
        BagItWriter.validateLabel((String)" foo");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelStartsWithSpace() {
        BagItWriter.validateLabel((String)" foo");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelEndsWithSpace() {
        BagItWriter.validateLabel((String)"foo ");
    }

    @Test(expected=RuntimeException.class)
    public void validateLabelEndsWithTab() {
        BagItWriter.validateLabel((String)"foo  ");
    }

    @Test
    public void encodeLineNoop() {
        Assert.assertEquals((Object)"foo", (Object)BagItWriter.encodeLine((String)"foo"));
    }

    @Test
    public void encodeLineCrAtStart() {
        Assert.assertEquals((Object)"%0Dfoo", (Object)BagItWriter.encodeLine((String)"\rfoo"));
    }

    @Test
    public void encodeLineCrAtEnd() {
        Assert.assertEquals((Object)"foo\r", (Object)BagItWriter.encodeLine((String)"foo\r"));
    }

    @Test
    public void encodeLineLfAtEnd() {
        Assert.assertEquals((Object)"foo\n", (Object)BagItWriter.encodeLine((String)"foo\n"));
    }

    @Test
    public void encodeLineCrLfAtEnd() {
        Assert.assertEquals((Object)"foo\r\n", (Object)BagItWriter.encodeLine((String)"foo\r\n"));
    }

    @Test
    public void encodeLineCrLf() {
        Assert.assertEquals((Object)"foo%0D%0Abar", (Object)BagItWriter.encodeLine((String)"foo\r\nbar"));
    }

    @Test
    public void encodeLinePercentWithLfAtEnd() {
        Assert.assertEquals((Object)"%25foo%25\n", (Object)BagItWriter.encodeLine((String)"%foo%\n"));
    }

    @Test
    public void encodePathNoop() {
        Assert.assertEquals((Object)"foo", (Object)BagItWriter.encodePath((String)"foo"));
    }

    @Test
    public void encodePathCrAtStart() {
        Assert.assertEquals((Object)"%0Dfoo", (Object)BagItWriter.encodePath((String)"\rfoo"));
    }

    @Test
    public void encodePathCrAtEnd() {
        Assert.assertEquals((Object)"foo%0D", (Object)BagItWriter.encodePath((String)"foo\r"));
    }

    @Test
    public void encodePathLfAtEnd() {
        Assert.assertEquals((Object)"foo%0A", (Object)BagItWriter.encodePath((String)"foo\n"));
    }

    @Test
    public void encodePathCrLfAtEnd() {
        Assert.assertEquals((Object)"foo%0D%0A", (Object)BagItWriter.encodePath((String)"foo\r\n"));
    }

    @Test
    public void encodePathCrLf() {
        Assert.assertEquals((Object)"foo%0D%0Abar", (Object)BagItWriter.encodePath((String)"foo\r\nbar"));
    }

    @Test
    public void encodePathPercentWithLfAtEnd() {
        Assert.assertEquals((Object)"%25foo%25%0A", (Object)BagItWriter.encodePath((String)"%foo%\n"));
    }

    @Test
    public void usesCharsetOnConstruction() throws IOException {
        String acuteEUtf16 = "\u00e9";
        byte[] expectedBytes = new byte[]{-61, -87};
        BagItWriter writer = new BagItWriter(StandardCharsets.UTF_8);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.writeTagLine((OutputStream)out, "test", acuteEUtf16);
        byte[] result = out.toByteArray();
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])new byte[]{result[result.length - 3], result[result.length - 2]});
    }
}

