/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.bagit;

import edu.jhu.library.pass.deposit.provider.bagit.BagItAssembler;
import edu.jhu.library.pass.deposit.provider.bagit.BagItPackageVerifier;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.dataconservancy.pass.client.PassClient;
import org.dataconservancy.pass.client.PassJsonAdapter;
import org.dataconservancy.pass.client.adapter.PassJsonAdapterBasic;
import org.dataconservancy.pass.deposit.assembler.Assembler;
import org.dataconservancy.pass.deposit.assembler.PackageOptions;
import org.dataconservancy.pass.deposit.assembler.shared.PackageVerifier;
import org.dataconservancy.pass.deposit.assembler.shared.ThreadedAssemblyIT;
import org.dataconservancy.pass.deposit.builder.fs.FilesystemModelBuilder;
import org.dataconservancy.pass.model.Submission;
import org.dataconservancy.pass.model.User;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import submissions.SubmissionResourceUtil;

public class BagItThreadedAssemblyIT
extends ThreadedAssemblyIT {
    private PassClient passClient = (PassClient)Mockito.mock(PassClient.class);
    private PassJsonAdapter adapter;
    private Map<URI, Submission> submissionMap;
    private Map<URI, User> userMap;

    @Before
    public void setUp() {
        this.builder = new FilesystemModelBuilder();
        this.adapter = new PassJsonAdapterBasic();
        Collection submissionUris = SubmissionResourceUtil.submissionUris();
        this.submissionMap = submissionUris.stream().peek(uri -> System.err.println("Processing " + uri)).map(SubmissionResourceUtil::asJson).flatMap(SubmissionResourceUtil::asStream).filter(node -> node.has("@id") && node.has("@type") && node.get("@type").asText().equals("Submission")).collect(Collectors.toMap(node -> URI.create(node.get("@id").asText()), node -> {
            try {
                return (Submission)this.adapter.toModel(IOUtils.toInputStream((String)node.toString(), (Charset)StandardCharsets.UTF_8), Submission.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        this.userMap = submissionUris.stream().map(SubmissionResourceUtil::asJson).flatMap(SubmissionResourceUtil::asStream).filter(node -> node.has("@id") && node.has("@type") && node.get("@type").asText().equals("User")).collect(Collectors.toMap(node -> URI.create(node.get("@id").asText()), node -> {
            try {
                return (User)this.adapter.toModel(IOUtils.toInputStream((String)node.toString(), (Charset)StandardCharsets.UTF_8), User.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (user1, user2) -> user2));
        Mockito.when((Object)this.passClient.readResource((URI)ArgumentMatchers.any(URI.class), (Class)ArgumentMatchers.eq(Submission.class))).then(inv -> this.submissionMap.get(inv.getArgument(0)));
        Mockito.when((Object)this.passClient.readResource((URI)ArgumentMatchers.any(URI.class), (Class)ArgumentMatchers.eq(User.class))).then(inv -> this.userMap.get(inv.getArgument(0)));
    }

    protected Assembler assemblerUnderTest() {
        return new BagItAssembler(this.mbf, this.rbf, this.passClient);
    }

    protected Map<String, Object> packageOptions() {
        return new HashMap<String, Object>(){
            {
                this.put("SPEC", "BagIt 1.0");
                this.put("ARCHIVE", PackageOptions.Archive.OPTS.ZIP);
                this.put("COMPRESSION", PackageOptions.Compression.OPTS.NONE);
                this.put("ALGO", Arrays.asList(PackageOptions.Checksum.OPTS.SHA512));
                this.put("baginfo-template-resource", "/bag-info.hbm");
            }
        };
    }

    protected PackageVerifier packageVerifier() {
        return new BagItPackageVerifier();
    }
}

