/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.bagit;

import edu.jhu.library.pass.deposit.provider.bagit.BagItReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class BagItReaderTest {
    private static final String PERCENT_DOUBLE_ENCODED_SPACE = "%2520";
    private static final String FILENAME_WITH_ENCODED_SPACE = "file%20with%20space";
    private static final String FILENAME_WITH_LF = "file\nwith\nlf";
    private static final String FILENAME_WITH_ENCODED_LF = "file%0Awith%0Alf";
    private static final String FILENAME_WITH_CR = "file\rwith\rlf";
    private static final String FILENAME_WITH_ENCODED_CR = "file%0Dwith%0Dlf";
    private static final String FILENAME_WITH_DOUBLE_ENCODED_SPACE = "file%2520with%2520space";
    private static final String BAG_INFO = "Source-Organization: Johns Hopkins\nOrganization-Address: 3400 N. Charles St, Baltimore, MD 21218\nContact-Name: Joe Contact\nContact-Phone: joecontact@jhu.edu\nContact-Email: 555-555-5555\nContact-Name: Jane Contact\nContact-Phone: janecontact@jhu.edu\nContact-Email: 123-456-7890\nExternal-Description: Submitted as uri:uuid:cf7a14da-8db4-4323-a15f-cff635ba6168 to PASS on 20190508T151013Z by Joe User (joeuser@user.com), published as 10.1039/c7fo01251a\nBagging-Date: 2019-05-07\nExternal-Identifier: 10.1039/c7fo01251a\nBag-Size: 15 GiB\nPayload-Oxum: 300.16106127360\nInternal-Sender-Identifier: uri:uuid:cf7a14da-8db4-4323-a15f-cff635ba6168\nInternal-Sender-Description: Submitted as uri:uuid:cf7a14da-8db4-4323-a15f-cff635ba6168 to PASS on 20190508T151013Z by Joe User (joeuser@user.com), published as 10.1039/c7fo01251a\n";
    private static final String BAG_INFO_UTF16 = "Contact-Name: \u00e9\n";
    private static final String BAG_DECL = "BagIt-Version: 1.0\nTag-File-Character-Encoding: UTF-8\n";
    private static final String MANIFEST = "hexchecksum_1 data/path/to/file.txt\nhexchecksum_2\tdata/path/to/file2.txt\nhexchecksum_3  data/path/to/file3.txt\nhexchecksum_4\t\tdata/path/to/file4.txt\nhexchecksum_5\t data/path/to/file5.txt\nhexchecksum_6 \tdata/path/to/file6.txt\nhexchecksum_7 \t data/path/to/file7.txt\nhexchecksum_8\t \tdata/path/to/file8.txt\nhexchecksum_1 data/path/to/file9.txt\nhexchecksum_1 data/file%2520with%2520space\n";
    private BagItReader reader = new BagItReader(StandardCharsets.UTF_8);

    @Test
    public void readEncoding() {
        Charset readerEncoding = StandardCharsets.UTF_16;
        this.reader = new BagItReader(readerEncoding);
        byte[] input = BAG_INFO_UTF16.getBytes(StandardCharsets.UTF_16);
        Assert.assertArrayEquals((byte[])new byte[]{0, -23}, (byte[])new byte[]{input[input.length - 4], input[input.length - 3]});
        LinkedHashMap<String, List<String>> labelAndValue = this.reader.readLabelsAndValues(IOUtils.toInputStream((String)BAG_INFO_UTF16, (Charset)readerEncoding));
        String value = (String)((List)labelAndValue.get("Contact-Name")).get(0);
        Assert.assertArrayEquals((byte[])new byte[]{-61, -87}, (byte[])value.getBytes(StandardCharsets.UTF_8));
        Assert.assertArrayEquals((byte[])new byte[]{-2, -1, 0, -23}, (byte[])value.getBytes(StandardCharsets.UTF_16));
    }

    @Test
    public void readBagDecl() {
        LinkedHashMap<String, String> decl = this.reader.readBagDecl(IOUtils.toInputStream((String)BAG_DECL, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((long)2L, (long)decl.size());
        Assert.assertEquals((Object)"1.0", decl.get("BagIt-Version"));
        Assert.assertEquals((Object)"UTF-8", decl.get("Tag-File-Character-Encoding"));
    }

    @Test
    public void readManifest() {
        LinkedHashMap<String, String> manifest = this.reader.readManifest(IOUtils.toInputStream((String)MANIFEST, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((long)10L, (long)manifest.size());
        Assert.assertEquals((Object)"hexchecksum_1", manifest.get("data/path/to/file.txt"));
        Assert.assertEquals((Object)"hexchecksum_2", manifest.get("data/path/to/file2.txt"));
        Assert.assertEquals((Object)"hexchecksum_3", manifest.get("data/path/to/file3.txt"));
        Assert.assertEquals((Object)"hexchecksum_4", manifest.get("data/path/to/file4.txt"));
        Assert.assertEquals((Object)"hexchecksum_5", manifest.get("data/path/to/file5.txt"));
        Assert.assertEquals((Object)"hexchecksum_6", manifest.get("data/path/to/file6.txt"));
        Assert.assertEquals((Object)"hexchecksum_7", manifest.get("data/path/to/file7.txt"));
        Assert.assertEquals((Object)"hexchecksum_8", manifest.get("data/path/to/file8.txt"));
        Assert.assertEquals((Object)"hexchecksum_1", manifest.get("data/path/to/file9.txt"));
        Assert.assertEquals((Object)"hexchecksum_1", manifest.get("data/file%20with%20space"));
    }

    @Test
    public void labels() {
        List<String> labels = this.reader.readLabels(IOUtils.toInputStream((String)BAG_INFO, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((long)15L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Bag-Size"));
        Assert.assertEquals((Object)"Internal-Sender-Description", (Object)labels.get(labels.size() - 1));
        Assert.assertEquals((Object)"Source-Organization", (Object)labels.get(0));
    }

    @Test
    public void labelsAndValues() {
        LinkedHashMap<String, List<String>> labelsAndValues = this.reader.readLabelsAndValues(IOUtils.toInputStream((String)BAG_INFO, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((long)12L, (long)labelsAndValues.size());
        Assert.assertTrue((boolean)labelsAndValues.containsKey("Contact-Name"));
        List contactNames = (List)labelsAndValues.get("Contact-Name");
        Assert.assertEquals((long)2L, (long)contactNames.size());
        Assert.assertEquals((Object)"Joe Contact", contactNames.get(0));
        Assert.assertEquals((Object)"Jane Contact", contactNames.get(1));
        Iterator itr = labelsAndValues.entrySet().iterator();
        Map.Entry entry = itr.next();
        Assert.assertEquals((Object)"Source-Organization", entry.getKey());
        Assert.assertEquals((Object)"Johns Hopkins", ((List)entry.getValue()).get(0));
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        while (itr.hasNext()) {
            entry = itr.next();
        }
        Assert.assertEquals((Object)"Internal-Sender-Description", entry.getKey());
        Assert.assertEquals((Object)"Submitted as uri:uuid:cf7a14da-8db4-4323-a15f-cff635ba6168 to PASS on 20190508T151013Z by Joe User (joeuser@user.com), published as 10.1039/c7fo01251a", ((List)entry.getValue()).get(0));
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
    }

    @Test
    public void decodePathWithDoubleEncodedSpace() {
        Assert.assertEquals((Object)FILENAME_WITH_ENCODED_SPACE, (Object)BagItReader.decodePath(FILENAME_WITH_DOUBLE_ENCODED_SPACE));
    }

    @Test
    public void decodePathWithEncodedLf() {
        Assert.assertEquals((Object)FILENAME_WITH_LF, (Object)BagItReader.decodePath(FILENAME_WITH_ENCODED_LF));
    }

    @Test
    public void decodePathWithEncodedCr() {
        Assert.assertEquals((Object)FILENAME_WITH_CR, (Object)BagItReader.decodePath(FILENAME_WITH_ENCODED_CR));
    }

    @Test
    public void decodePathWithEndingCr() {
        Assert.assertEquals((Object)"foo\r", (Object)BagItReader.decodePath("foo%0D"));
    }

    @Test
    public void decodePathWithStartingCr() {
        Assert.assertEquals((Object)"\rfoo", (Object)BagItReader.decodePath("%0Dfoo"));
    }

    @Test
    public void decodeKitchenSink() {
        Assert.assertEquals((Object)"%foo bar%\nbaz%", (Object)BagItReader.decodePath("%25foo bar%25%0Abaz%25"));
    }
}

