/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.bagit;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class BagItReader {
    private static final String SEP_SPACE = " ";
    private static final String SEP_TAB = "\t";
    private static final String LABEL_SEP_SPACE = ": ";
    private static final String LABEL_SEP_TAB = ":\t";
    private Charset charset;

    public BagItReader(Charset charset) {
        this.charset = charset;
    }

    LinkedHashMap<String, String> readBagDecl(InputStream bagDeclaration) {
        List lines = null;
        try {
            lines = IOUtils.readLines((InputStream)bagDeclaration, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, List<String>> entriesAndValues = this.parseLines(lines);
        return entriesAndValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0), (entry1, entry2) -> {
            throw new RuntimeException("Duplicate label: " + entry1);
        }, LinkedHashMap::new));
    }

    LinkedHashMap<String, String> readManifest(InputStream manifest) {
        List lines = null;
        try {
            lines = IOUtils.readLines((InputStream)manifest, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, String> entriesAndValues = this.parseManifestLines(lines);
        return entriesAndValues;
    }

    List<String> readLabels(InputStream bagInfo) {
        List lines = null;
        try {
            lines = IOUtils.readLines((InputStream)bagInfo, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return lines.stream().filter(line -> line.contains(LABEL_SEP_SPACE) || line.contains(LABEL_SEP_TAB)).map(line -> {
            if (line.contains(LABEL_SEP_SPACE)) {
                return line.substring(0, line.indexOf(LABEL_SEP_SPACE));
            }
            return line.substring(0, line.indexOf(LABEL_SEP_TAB));
        }).collect(Collectors.toList());
    }

    LinkedHashMap<String, List<String>> readLabelsAndValues(InputStream bagInfo) {
        List lines = null;
        try {
            lines = IOUtils.readLines((InputStream)bagInfo, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.parseLines(lines);
    }

    static String decodePath(String path) {
        StringBuilder encodedPath = new StringBuilder(path);
        StringBuilder decodedPath = new StringBuilder(path);
        HashMap<String, String> DECODE_MAP = new HashMap<String, String>(){
            {
                this.put("%0A", String.valueOf('\n'));
                this.put("%0D", String.valueOf('\r'));
                this.put("%25", String.valueOf('%'));
            }
        };
        Stream.of("%0A", "%0D", "%25").forEach(encodedToken -> {
            int offset = 0;
            int index = -1;
            int replacementOffset = 0;
            while ((index = encodedPath.indexOf((String)encodedToken, offset)) > -1) {
                decodedPath.replace(index + replacementOffset, index + replacementOffset + encodedToken.length(), (String)DECODE_MAP.get(encodedToken));
                replacementOffset -= encodedToken.length() - ((String)DECODE_MAP.get(encodedToken)).length();
                offset = index + encodedToken.length();
            }
            encodedPath.setLength(decodedPath.length());
            for (int i = 0; i < decodedPath.length(); ++i) {
                encodedPath.setCharAt(i, decodedPath.charAt(i));
            }
        });
        return decodedPath.toString();
    }

    private LinkedHashMap<String, List<String>> parseLines(List<String> lines) {
        return lines.stream().filter(line -> line.contains(LABEL_SEP_SPACE) || line.contains(LABEL_SEP_TAB)).collect(Collectors.toMap(line -> {
            if (line.contains(LABEL_SEP_SPACE)) {
                return line.substring(0, line.indexOf(LABEL_SEP_SPACE));
            }
            return line.substring(0, line.indexOf(LABEL_SEP_TAB));
        }, line -> {
            String value = line.contains(LABEL_SEP_SPACE) ? line.substring(line.indexOf(LABEL_SEP_SPACE) + LABEL_SEP_SPACE.length()) : line.substring(line.indexOf(LABEL_SEP_TAB) + LABEL_SEP_TAB.length());
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(value);
            return list;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }, LinkedHashMap::new));
    }

    private LinkedHashMap<String, String> parseManifestLines(List<String> lines) {
        return lines.stream().filter(line -> line.contains(SEP_SPACE) || line.contains(SEP_TAB)).collect(Collectors.toMap(line -> {
            String[] result = line.split("\\h");
            return BagItReader.decodePath(result[result.length - 1]);
        }, line -> line.split("\\h")[0], (value1, value2) -> {
            throw new RuntimeException("Duplicate file path in manifest: " + value1);
        }, LinkedHashMap::new));
    }
}

