/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.library.pass.deposit.provider.bagit;

import edu.jhu.library.pass.deposit.provider.bagit.BagItReader;
import edu.jhu.library.pass.deposit.provider.bagit.BagItVersion;
import edu.jhu.library.pass.deposit.provider.bagit.BagItWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.MessageDigestCalculatingInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.dataconservancy.pass.deposit.assembler.PackageOptions;
import org.dataconservancy.pass.deposit.assembler.shared.ExplodedPackage;
import org.dataconservancy.pass.deposit.assembler.shared.PackageVerifier;
import org.dataconservancy.pass.deposit.model.DepositFile;
import org.dataconservancy.pass.deposit.model.DepositSubmission;
import org.junit.Assert;

public class BagItPackageVerifier
implements PackageVerifier {
    private BagItReader reader;
    private Charset expectedEncoding = StandardCharsets.UTF_8;

    public BagItPackageVerifier() {
        this.reader = new BagItReader(this.expectedEncoding);
    }

    public BagItPackageVerifier(BagItReader reader) {
        this.reader = reader;
    }

    public void verify(DepositSubmission depositSubmission, ExplodedPackage explodedPackage, Map<String, Object> map) throws Exception {
        File payloadDir = new File(explodedPackage.getExplodedDir(), "data");
        Assert.assertTrue((String)("Missing payload directory: " + payloadDir), (boolean)payloadDir.exists());
        BiFunction<File, File, DepositFile> MAPPER = (packageDir, payloadFile) -> depositSubmission.getFiles().stream().filter(df -> BagItWriter.encodePath((String)df.getName()).endsWith(payloadFile.getName())).findAny().orElseThrow(() -> new RuntimeException("Missing custodial file '" + payloadFile + "'"));
        FileFilter payloadFilter = file -> {
            File parent;
            if (!file.isFile()) {
                return false;
            }
            File file2 = parent = file.getParentFile() != null ? file.getParentFile() : file;
            do {
                if (!parent.equals(payloadDir)) continue;
                return true;
            } while ((parent = parent.getParentFile()) != null);
            return false;
        };
        this.verifyCustodialFiles(depositSubmission, explodedPackage.getExplodedDir(), payloadFilter, MAPPER);
        List<PackageOptions.Checksum.OPTS> checksums = null;
        checksums = map == null || map.isEmpty() ? Arrays.asList(PackageOptions.Checksum.OPTS.SHA512, PackageOptions.Checksum.OPTS.MD5) : (List<PackageOptions.Checksum.OPTS>)map.get("ALGO");
        Assert.assertTrue((String)"Package options must specify at least one checksum.", (checksums.size() > 0 ? 1 : 0) != 0);
        checksums.forEach(algorithm -> {
            File manifest = new File(explodedPackage.getExplodedDir(), String.format("manifest-%s.txt", algorithm.name().toLowerCase()));
            File tagManifest = new File(explodedPackage.getExplodedDir(), String.format("tagmanifest-%s.txt", algorithm.name().toLowerCase()));
            this.verifyManifest(depositSubmission.getFiles(), explodedPackage.getExplodedDir(), manifest, (PackageOptions.Checksum.OPTS)algorithm);
            this.verifyTagManifest(explodedPackage.getExplodedDir(), tagManifest, (PackageOptions.Checksum.OPTS)algorithm);
        });
        File bagDecl = new File(explodedPackage.getExplodedDir(), "bagit.txt");
        this.verifyBagDecl(bagDecl, BagItVersion.BAGIT_1_0.getVersionString());
        File bagInfo = new File(explodedPackage.getExplodedDir(), "bag-info.txt");
        this.verifyBagInfo(bagInfo);
    }

    protected void verifyBagInfo(File bagInfo) {
        LinkedHashMap<String, List<String>> entries;
        try {
            entries = this.reader.readLabelsAndValues(new FileInputStream(bagInfo));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Missing Bag info file: '" + bagInfo + "'", e);
        }
        Assert.assertTrue((entries.size() > 0 ? 1 : 0) != 0);
    }

    protected void verifyBagDecl(File bagDecl, String expectedVersion) {
        LinkedHashMap<String, String> entries;
        try {
            entries = this.reader.readBagDecl(new FileInputStream(bagDecl));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Missing Bag declaration file: '" + bagDecl + "'", e);
        }
        Assert.assertEquals((Object)expectedVersion, entries.get("BagIt-Version"));
        Assert.assertEquals((Object)this.expectedEncoding.name(), entries.get("Tag-File-Character-Encoding"));
    }

    protected void verifyTagManifest(File packageDir, File tagManifestFile, PackageOptions.Checksum.OPTS algo) {
        LinkedHashMap<String, String> manifest;
        Assert.assertTrue((String)("Missing expected tag manifest '" + tagManifestFile + "'"), (boolean)tagManifestFile.exists());
        Assert.assertEquals((Object)String.format("tagmanifest-%s.txt", algo.name().toLowerCase()), (Object)tagManifestFile.getName());
        try {
            manifest = this.reader.readManifest(new FileInputStream(tagManifestFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error reading tag manifest " + tagManifestFile + ": " + e.getMessage(), e);
        }
        manifest.keySet().forEach(expectedTagFile -> {
            Assert.assertTrue((boolean)new File(packageDir, (String)expectedTagFile).exists());
            Assert.assertFalse((boolean)expectedTagFile.startsWith("data"));
        });
        manifest.forEach((key, value) -> {
            File payloadFile = new File(packageDir, (String)key);
            try (NullOutputStream nullOut = new NullOutputStream();
                 FileInputStream fileIn = new FileInputStream(payloadFile);
                 MessageDigestCalculatingInputStream xsumCalculator = BagItPackageVerifier.checksumCalculatorFor(fileIn, algo);){
                IOUtils.copy((InputStream)xsumCalculator, (OutputStream)nullOut);
                Assert.assertEquals((Object)value, (Object)Hex.encodeHexString((byte[])xsumCalculator.getMessageDigest().digest()));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Missing expected tag manifest file: " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected void verifyManifest(List<DepositFile> payload, File packageDir, File manifestFile, PackageOptions.Checksum.OPTS algo) {
        LinkedHashMap<String, String> manifest;
        Assert.assertTrue((String)("Missing expected manifest file '" + manifestFile + "'"), (boolean)manifestFile.exists());
        Assert.assertEquals((Object)String.format("manifest-%s.txt", algo.name().toLowerCase()), (Object)manifestFile.getName());
        try {
            manifest = this.reader.readManifest(new FileInputStream(manifestFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error reading manifest " + manifestFile + ": " + e.getMessage(), e);
        }
        payload.forEach(df -> {
            String encodedLocation = BagItWriter.encodePath((String)df.getName());
            String relative = null;
            relative = encodedLocation.contains("/") ? "data" + encodedLocation.substring(encodedLocation.lastIndexOf("/")) : "data/" + encodedLocation;
            File expectedPayloadFile = new File(packageDir, relative);
            Assert.assertTrue((String)("Missing expected payload file '" + expectedPayloadFile + "'"), (boolean)expectedPayloadFile.exists());
            Assert.assertTrue((String)("Missing payload file '" + relative + "' from the manifest (package directory: " + packageDir + "')"), (boolean)manifest.containsKey(relative));
        });
        manifest.keySet().forEach(expectedPayloadFile -> {
            Assert.assertTrue((boolean)new File(packageDir, (String)expectedPayloadFile).exists());
            Assert.assertTrue((boolean)expectedPayloadFile.startsWith("data"));
        });
        manifest.forEach((key, value) -> {
            File payloadFile = new File(packageDir, (String)key);
            try (NullOutputStream nullOut = new NullOutputStream();
                 FileInputStream fileIn = new FileInputStream(payloadFile);
                 MessageDigestCalculatingInputStream xsumCalculator = BagItPackageVerifier.checksumCalculatorFor(fileIn, algo);){
                IOUtils.copy((InputStream)xsumCalculator, (OutputStream)nullOut);
                Assert.assertEquals((Object)value, (Object)Hex.encodeHexString((byte[])xsumCalculator.getMessageDigest().digest()));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Missing expected payload file: " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static MessageDigestCalculatingInputStream checksumCalculatorFor(InputStream payloadFile, PackageOptions.Checksum.OPTS checksumAlgo) {
        MessageDigest md;
        try {
            switch (checksumAlgo) {
                case MD5: {
                    md = MessageDigest.getInstance("MD5");
                    break;
                }
                case SHA256: {
                    md = MessageDigest.getInstance("SHA-256");
                    break;
                }
                case SHA512: {
                    md = MessageDigest.getInstance("SHA-512");
                    break;
                }
                default: {
                    throw new RuntimeException("No MessageDigest implementation found for " + checksumAlgo.name());
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return new MessageDigestCalculatingInputStream(payloadFile, md);
    }
}

