/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.transport.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dataconservancy.pass.deposit.assembler.PackageStream;
import org.dataconservancy.pass.deposit.transport.Transport;
import org.dataconservancy.pass.deposit.transport.TransportResponse;
import org.dataconservancy.pass.deposit.transport.TransportSession;
import org.dataconservancy.pass.model.Deposit;
import org.dataconservancy.pass.model.PassEntity;
import org.dataconservancy.pass.model.RepositoryCopy;
import org.dataconservancy.pass.model.Submission;
import org.dataconservancy.pass.support.messaging.cri.CriticalRepositoryInteraction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilesystemTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemTransport.class);
    private CriticalRepositoryInteraction cri;
    private File baseDir;
    private boolean createIfMissing;
    private boolean overwrite;

    @Autowired
    public FilesystemTransport(CriticalRepositoryInteraction cri) {
        this.cri = cri;
    }

    public Transport.PROTOCOL protocol() {
        return Transport.PROTOCOL.filesystem;
    }

    public TransportSession open(Map<String, String> hints) {
        this.baseDir = new File(hints.get("baseDir"));
        this.createIfMissing = Boolean.parseBoolean(hints.getOrDefault("createIfMissing", "true"));
        this.overwrite = Boolean.parseBoolean(hints.getOrDefault("overwrite", "false"));
        if (!this.baseDir.exists()) {
            if (this.createIfMissing) {
                try {
                    FileUtils.forceMkdir((File)this.baseDir);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error creating base directory '" + this.baseDir + "' " + e.getMessage(), e);
                }
            } else {
                throw new RuntimeException("Base directory '" + this.baseDir + "' does not exist.");
            }
        }
        return new FilesystemTransportSession();
    }

    private void verifySuccess(PassEntity entity, CriticalRepositoryInteraction.CriticalResult<?, ?> result) {
        if (!result.success()) {
            if (result.throwable().isPresent()) {
                throw new RuntimeException((Throwable)result.throwable().get());
            }
            throw new RuntimeException("Failed to update " + entity.getId());
        }
    }

    class FilesystemTransportSession
    implements TransportSession {
        FilesystemTransportSession() {
        }

        public TransportResponse send(PackageStream packageStream, Map<String, String> metadata) {
            String filename = packageStream.metadata().name();
            final AtomicReference<Exception> transportException = new AtomicReference<Exception>();
            final File outputFile = new File(FilesystemTransport.this.baseDir, filename);
            if (!outputFile.exists() || FilesystemTransport.this.overwrite) {
                try (InputStream in = packageStream.open();
                     FileOutputStream out = new FileOutputStream(outputFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Exception e) {
                    transportException.set(e);
                }
            } else {
                transportException.set(new IOException("Output file '" + outputFile + "' already exists, and 'overwrite' flag is 'false'"));
            }
            return new TransportResponse(){

                public boolean success() {
                    return transportException.get() == null;
                }

                public Throwable error() {
                    return (Throwable)transportException.get();
                }

                public void onSuccess(Submission submission, Deposit deposit, RepositoryCopy repositoryCopy) {
                    LOG.trace("Invoking onSuccess for tuple [{} {} {}]", new Object[]{submission.getId(), deposit.getId(), repositoryCopy.getId()});
                    CriticalRepositoryInteraction.CriticalResult rcCr = FilesystemTransport.this.cri.performCritical(repositoryCopy.getId(), RepositoryCopy.class, rc -> outputFile.exists(), rc -> rc.getCopyStatus() == RepositoryCopy.CopyStatus.COMPLETE && rc.getExternalIds().size() > 0 && rc.getAccessUrl() != null, rc -> {
                        rc.getExternalIds().add(outputFile.toURI().toString());
                        rc.setCopyStatus(RepositoryCopy.CopyStatus.COMPLETE);
                        rc.setAccessUrl(outputFile.toURI());
                        return rc;
                    });
                    FilesystemTransport.this.verifySuccess((PassEntity)repositoryCopy, rcCr);
                    LOG.trace("onSuccess updated RepositoryCopy {}", (Object)((RepositoryCopy)rcCr.resource().get()).getId());
                    CriticalRepositoryInteraction.CriticalResult depositCr = FilesystemTransport.this.cri.performCritical(deposit.getId(), Deposit.class, criDeposit -> Deposit.DepositStatus.SUBMITTED == criDeposit.getDepositStatus(), criDeposit -> Deposit.DepositStatus.ACCEPTED == criDeposit.getDepositStatus(), criDeposit -> {
                        criDeposit.setDepositStatus(Deposit.DepositStatus.ACCEPTED);
                        return criDeposit;
                    });
                    FilesystemTransport.this.verifySuccess((PassEntity)deposit, depositCr);
                    LOG.trace("onSuccess updated Deposit {}", (Object)((Deposit)depositCr.resource().get()).getId());
                }
            };
        }

        public boolean closed() {
            return false;
        }

        public void close() throws Exception {
        }
    }
}

