/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.model;

import java.util.Arrays;

public enum JournalPublicationType {
    PPUB("Print"),
    EPUB("Electronic"),
    OPUB("Online");

    private String typeDescription;

    private JournalPublicationType(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public static JournalPublicationType parseTypeDescription(String typeDescription) {
        return Arrays.stream(JournalPublicationType.values()).filter(candidatePubType -> candidatePubType.getTypeDescription().equals(typeDescription)).findAny().orElseThrow(() -> new IllegalArgumentException("No JournalPublicationType exists for '" + typeDescription + "'"));
    }

    public String toString() {
        return "JournalPublicationType{typeDescription='" + this.typeDescription + '\'' + "} " + super.toString();
    }
}

