/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.deposit.model;

import java.net.URI;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dataconservancy.pass.deposit.model.JournalPublicationType;

public class DepositMetadata {
    private Manuscript manuscriptMetadata = new Manuscript();
    private Journal journalMetadata = new Journal();
    private List<Person> persons;
    private Article articleMetadata = new Article();

    public DepositMetadata() {
        this.persons = new ArrayList<Person>();
    }

    public Manuscript getManuscriptMetadata() {
        return this.manuscriptMetadata;
    }

    public void setManuscriptMetadata(Manuscript manuscriptMetadata) {
        this.manuscriptMetadata = manuscriptMetadata;
    }

    public Journal getJournalMetadata() {
        return this.journalMetadata;
    }

    public void setJournalMetadata(Journal journalMetadata) {
        this.journalMetadata = journalMetadata;
    }

    public List<Person> getPersons() {
        return this.persons;
    }

    public void setPersons(List<Person> persons) {
        this.persons = persons;
    }

    public Article getArticleMetadata() {
        return this.articleMetadata;
    }

    public void setArticleMetadata(Article articleMetadata) {
        this.articleMetadata = articleMetadata;
    }

    public String toString() {
        return "DepositMetadata{manuscriptMetadata=" + this.manuscriptMetadata + ", journalMetadata=" + this.journalMetadata + ", persons=" + this.persons + ", articleMetadata=" + this.articleMetadata + '}';
    }

    public static class Person {
        public String fullName;
        public String firstName;
        public String middleName;
        public String lastName;
        public String email;
        public PERSON_TYPE type;

        public Person() {
        }

        public Person(Person otherPerson) {
            this.setFullName(otherPerson.getFullName());
            this.setFirstName(otherPerson.getFirstName());
            this.setMiddleName(otherPerson.getMiddleName());
            this.setLastName(otherPerson.getLastName());
            this.setType(otherPerson.getType());
        }

        public String getConstructedName() {
            if (this.getFirstName() != null && this.getLastName() != null) {
                if (this.getMiddleName() != null) {
                    return String.format("%s %s %s", this.getFirstName(), this.getMiddleName(), this.getLastName());
                }
                return String.format("%s %s", this.getFirstName(), this.getLastName());
            }
            return "";
        }

        public String getName() {
            if (this.getFullName() != null) {
                return this.getFullName();
            }
            return this.getConstructedName();
        }

        public String getReversedName() {
            if (this.getFirstName() != null && this.getLastName() != null) {
                if (this.getMiddleName() != null) {
                    return String.format("%s, %s %s", this.getLastName(), this.getFirstName(), this.getMiddleName());
                }
                return String.format("%s, %s", this.getLastName(), this.getFirstName());
            }
            return this.getFullName();
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public PERSON_TYPE getType() {
            return this.type;
        }

        public void setType(PERSON_TYPE type) {
            this.type = type;
        }
    }

    public static class Article {
        public URI doi;
        public String volume;
        public String issue;
        public String title;
        public ZonedDateTime embargoLiftDate = null;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getVolume() {
            return this.volume;
        }

        public void setVolume(String volume) {
            this.volume = volume;
        }

        public String getIssue() {
            return this.issue;
        }

        public void setIssue(String issue) {
            this.issue = issue;
        }

        public URI getDoi() {
            return this.doi;
        }

        public void setDoi(URI doi) {
            this.doi = doi;
        }

        public ZonedDateTime getEmbargoLiftDate() {
            return this.embargoLiftDate;
        }

        public void setEmbargoLiftDate(ZonedDateTime embargoLiftDate) {
            this.embargoLiftDate = embargoLiftDate;
        }
    }

    public static class Journal {
        public String journalId;
        public String journalType = "nlm-ta";
        public String journalTitle;
        public String publisherName;
        public String publicationDate;
        public Map<String, IssnPubType> issnPubTypes = new HashMap<String, IssnPubType>(2);
        @Deprecated
        public String issn;

        public String getJournalId() {
            return this.journalId;
        }

        public void setJournalId(String journalId) {
            this.journalId = journalId;
        }

        public String getJournalType() {
            return this.journalType;
        }

        public String getJournalTitle() {
            return this.journalTitle;
        }

        public void setJournalTitle(String journalTitle) {
            this.journalTitle = journalTitle;
        }

        public String getPublisherName() {
            return this.publisherName;
        }

        public void setPublisherName(String publisherName) {
            this.publisherName = publisherName;
        }

        public String getPublicationDate() {
            return this.publicationDate;
        }

        public void setPublicationDate(String publicationDate) {
            this.publicationDate = publicationDate;
        }

        public Map<String, IssnPubType> getIssnPubTypes() {
            return this.issnPubTypes;
        }

        public void setIssnPubTypes(Map<String, IssnPubType> issnPubTypes) {
            this.issnPubTypes = issnPubTypes;
        }

        @Deprecated
        public String getIssn() {
            return this.issn;
        }

        @Deprecated
        public void setIssn(String issn) {
            this.issn = issn;
        }
    }

    public static class Manuscript {
        public String nihmsId;
        public URL manuscriptUrl;
        public boolean publisherPdf;
        public boolean showPublisherPdf;
        public String title;
        public String msAbstract;

        public String getMsAbstract() {
            return this.msAbstract;
        }

        public void setMsAbstract(String msAbstract) {
            this.msAbstract = msAbstract;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getNihmsId() {
            return this.nihmsId;
        }

        public void setNihmsId(String nihmsId) {
            this.nihmsId = nihmsId;
        }

        public URL getManuscriptUrl() {
            return this.manuscriptUrl;
        }

        public void setManuscriptUrl(URL manuscriptUrl) {
            this.manuscriptUrl = manuscriptUrl;
        }

        public boolean isPublisherPdf() {
            return this.publisherPdf;
        }

        public void setPublisherPdf(boolean publisherPdf) {
            this.publisherPdf = publisherPdf;
        }

        public boolean isShowPublisherPdf() {
            return this.showPublisherPdf;
        }

        public void setShowPublisherPdf(boolean showPublisherPdf) {
            this.showPublisherPdf = showPublisherPdf;
        }
    }

    public static enum PERSON_TYPE {
        submitter,
        pi,
        copi,
        author;

    }

    public static class IssnPubType {
        public String issn;
        public JournalPublicationType pubType;

        public IssnPubType(String issn, JournalPublicationType pubType) {
            this.issn = issn;
            this.pubType = pubType;
        }

        public String toString() {
            return "IssnPubType{issn='" + this.issn + '\'' + ", pubType=" + (Object)((Object)this.pubType) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssnPubType that = (IssnPubType)o;
            if (!this.issn.equals(that.issn)) {
                return false;
            }
            return this.pubType == that.pubType;
        }

        public int hashCode() {
            int result = this.issn.hashCode();
            result = 31 * result + this.pubType.hashCode();
            return result;
        }
    }
}

